/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike;

import com.aerospike.client.Value;
import com.playtika.janusgraph.aerospike.AerospikeLock;
import com.playtika.janusgraph.aerospike.operations.AerospikeOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.common.AbstractStoreTransaction;

final class AerospikeTransaction
extends AbstractStoreTransaction {
    private final List<AerospikeLock> locks = new ArrayList<AerospikeLock>();

    AerospikeTransaction(BaseTransactionConfig config) {
        super(config);
    }

    public void commit() {
        this.locks.clear();
    }

    public void rollback() {
        this.locks.clear();
    }

    void addLock(AerospikeLock lock) {
        this.locks.add(lock);
    }

    List<AerospikeLock> getLocks() {
        return this.locks;
    }

    Map<String, Map<Value, Map<Value, Value>>> getLocksByStoreKeyColumn() {
        return this.locks.stream().collect(Collectors.groupingBy(lock -> lock.storeName, Collectors.groupingBy(lock -> AerospikeOperations.getValue(lock.key), Collectors.toMap(lock -> AerospikeOperations.getValue(lock.column), lock -> lock.expectedValue != null ? AerospikeOperations.getValue(lock.expectedValue) : Value.NULL, (oldValue, newValue) -> oldValue))));
    }

    public String toString() {
        return Integer.toHexString(((Object)((Object)this)).hashCode());
    }
}

