/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.operations;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cdt.MapOperation;
import com.aerospike.client.cdt.MapOrder;
import com.aerospike.client.cdt.MapPolicy;
import com.aerospike.client.cdt.MapWriteMode;
import com.aerospike.client.policy.WritePolicy;
import com.playtika.janusgraph.aerospike.AerospikePolicyProvider;
import com.playtika.janusgraph.aerospike.operations.AerospikeOperations;
import com.playtika.janusgraph.aerospike.operations.MutateOperations;
import com.playtika.janusgraph.aerospike.util.AsyncUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class BasicMutateOperations
implements MutateOperations {
    static final MapPolicy mapPolicy = new MapPolicy(MapOrder.KEY_ORDERED, MapWriteMode.UPDATE);
    private final WritePolicy mutatePolicy;
    private final WritePolicy deletePolicy;
    private AerospikeOperations aerospikeOperations;

    public BasicMutateOperations(AerospikeOperations aerospikeOperations) {
        this.aerospikeOperations = aerospikeOperations;
        AerospikePolicyProvider aerospikePolicyProvider = aerospikeOperations.getAerospikePolicyProvider();
        this.mutatePolicy = BasicMutateOperations.buildMutationPolicy(aerospikePolicyProvider);
        this.deletePolicy = aerospikePolicyProvider.deletePolicy();
    }

    @Override
    public void mutateMany(Map<String, Map<Value, Map<Value, Value>>> mutationsByStore, boolean wal) {
        ArrayList mutations = new ArrayList();
        mutationsByStore.forEach((storeName, storeMutations) -> {
            for (Map.Entry mutationEntry : storeMutations.entrySet()) {
                Value key = (Value)mutationEntry.getKey();
                Map mutation = (Map)mutationEntry.getValue();
                mutations.add(CompletableFuture.runAsync(() -> this.mutate((String)storeName, key, mutation, wal), this.aerospikeOperations.getAerospikeExecutor()));
            }
        });
        AsyncUtil.completeAll(mutations);
    }

    @Override
    public void mutate(String storeName, Value keyValue, Map<Value, Value> mutation, boolean wal) {
        long entriesNoAfterMutation;
        Record record;
        Key key = this.aerospikeOperations.getKey(storeName, keyValue);
        ArrayList<Operation> operations = new ArrayList<Operation>(3);
        ArrayList<Value> keysToRemove = new ArrayList<Value>(mutation.size());
        HashMap<Value, Value> itemsToAdd = new HashMap<Value, Value>(mutation.size());
        for (Map.Entry<Value, Value> entry : mutation.entrySet()) {
            if (entry.getValue() == Value.NULL) {
                keysToRemove.add(entry.getKey());
                continue;
            }
            itemsToAdd.put(entry.getKey(), entry.getValue());
        }
        if (!keysToRemove.isEmpty()) {
            operations.add(MapOperation.removeByKeyList((String)"entries", keysToRemove, (int)0, (CTX[])new CTX[0]));
        }
        if (!itemsToAdd.isEmpty()) {
            operations.add(MapOperation.putItems((MapPolicy)mapPolicy, (String)"entries", itemsToAdd, (CTX[])new CTX[0]));
        }
        int entriesNoOperationIndex = -1;
        if (!keysToRemove.isEmpty()) {
            entriesNoOperationIndex = operations.size();
            operations.add(MapOperation.size((String)"entries", (CTX[])new CTX[0]));
        }
        IAerospikeClient client = this.aerospikeOperations.getClient();
        try {
            record = client.operate(this.mutatePolicy, key, operations.toArray(new Operation[0]));
        }
        catch (AerospikeException ae) {
            if (wal && ae.getResultCode() == 2) {
                return;
            }
            throw ae;
        }
        if (entriesNoOperationIndex != -1 && (entriesNoAfterMutation = ((Long)record.getList("entries").get(entriesNoOperationIndex)).longValue()) == 0L) {
            client.delete(this.deletePolicy, key);
        }
    }

    private static WritePolicy buildMutationPolicy(AerospikePolicyProvider policyProvider) {
        WritePolicy mutatePolicy = new WritePolicy(policyProvider.writePolicy());
        mutatePolicy.respondAllOps = true;
        return mutatePolicy;
    }
}

