/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.operations;

import com.aerospike.client.IAerospikeClient;
import com.playtika.janusgraph.aerospike.AerospikePolicyProvider;
import com.playtika.janusgraph.aerospike.ConfigOptions;
import com.playtika.janusgraph.aerospike.operations.AerospikeOperations;
import com.playtika.janusgraph.aerospike.operations.BasicLockOperations;
import com.playtika.janusgraph.aerospike.operations.BasicMutateOperations;
import com.playtika.janusgraph.aerospike.operations.BasicScanOperations;
import com.playtika.janusgraph.aerospike.operations.LockOperations;
import com.playtika.janusgraph.aerospike.operations.MutateOperations;
import com.playtika.janusgraph.aerospike.operations.Operations;
import com.playtika.janusgraph.aerospike.operations.ReadOperations;
import com.playtika.janusgraph.aerospike.operations.ScanOperations;
import com.playtika.janusgraph.aerospike.operations.UnsupportedScanOperations;
import com.playtika.janusgraph.aerospike.transaction.TransactionalOperations;
import com.playtika.janusgraph.aerospike.transaction.WalOperations;
import com.playtika.janusgraph.aerospike.transaction.WriteAheadLogCompleter;
import com.playtika.janusgraph.aerospike.transaction.WriteAheadLogManager;
import com.playtika.janusgraph.aerospike.transaction.WriteAheadLogManagerBasic;
import com.playtika.janusgraph.aerospike.util.NamedThreadFactory;
import java.time.Clock;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.janusgraph.diskstorage.configuration.Configuration;

public class BasicOperations
implements Operations {
    public static final String JANUS_AEROSPIKE_THREAD_GROUP_NAME = "janus-aerospike";
    private final Configuration configuration;
    private final AerospikeOperations aerospikeOperations;
    private final WalOperations walOperations;
    private final WriteAheadLogManager writeAheadLogManager;
    private final LockOperations lockOperations;
    private final MutateOperations mutateOperations;
    private final TransactionalOperations transactionalOperations;
    private final WriteAheadLogCompleter writeAheadLogCompleter;
    private final ReadOperations readOperations;
    private final ScanOperations scanOperations;

    public BasicOperations(Configuration configuration) {
        this.configuration = configuration;
        this.aerospikeOperations = this.buildAerospikeOperations(configuration);
        this.walOperations = this.buildWalOperations(configuration, this.aerospikeOperations);
        this.writeAheadLogManager = this.buildWriteAheadLogManager(this.walOperations, this.getClock());
        this.lockOperations = this.buildLockOperations(this.aerospikeOperations);
        this.mutateOperations = this.buildMutateOperations(this.aerospikeOperations);
        this.transactionalOperations = this.buildTransactionalOperations(() -> this.writeAheadLogManager, () -> this.lockOperations, () -> this.mutateOperations);
        this.writeAheadLogCompleter = this.buildWriteAheadLogCompleter(this.walOperations, () -> this.writeAheadLogManager, () -> this.lockOperations, () -> this.mutateOperations);
        this.readOperations = this.buildReadOperations(configuration, this.aerospikeOperations);
        this.scanOperations = this.buildScanOperations(configuration, this.aerospikeOperations);
    }

    @Override
    public AerospikeOperations getAerospikeOperations() {
        return this.aerospikeOperations;
    }

    @Override
    public TransactionalOperations getTransactionalOperations() {
        return this.transactionalOperations;
    }

    @Override
    public WriteAheadLogCompleter getWriteAheadLogCompleter() {
        return this.writeAheadLogCompleter;
    }

    @Override
    public ReadOperations getReadOperations() {
        return this.readOperations;
    }

    @Override
    public ScanOperations getScanOperations() {
        return this.scanOperations;
    }

    protected AerospikePolicyProvider buildPolicyProvider(Configuration configuration) {
        return new AerospikePolicyProvider(configuration);
    }

    protected AerospikeOperations buildAerospikeOperations(Configuration configuration) {
        String namespace = (String)configuration.get(ConfigOptions.NAMESPACE, new String[0]);
        String graphPrefix = (String)configuration.get(ConfigOptions.GRAPH_PREFIX, new String[0]);
        AerospikePolicyProvider aerospikePolicyProvider = this.buildPolicyProvider(configuration);
        IAerospikeClient client = AerospikeOperations.buildAerospikeClient(configuration, aerospikePolicyProvider.clientPolicy());
        ThreadPoolExecutor aerospikeExecutor = this.buildExecutor(4, (Integer)configuration.get(ConfigOptions.AEROSPIKE_PARALLELISM, new String[0]), "main");
        ThreadPoolExecutor aerospikeGetExecutor = this.buildExecutor(4, (Integer)configuration.get(ConfigOptions.AEROSPIKE_READ_PARALLELISM, new String[0]), "get");
        return new AerospikeOperations(graphPrefix, namespace, client, aerospikePolicyProvider, aerospikeExecutor, aerospikeGetExecutor);
    }

    private ThreadPoolExecutor buildExecutor(int i, Integer integer, String main) {
        return new ThreadPoolExecutor(i, (int)integer, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(JANUS_AEROSPIKE_THREAD_GROUP_NAME, main));
    }

    protected WalOperations buildWalOperations(Configuration configuration, AerospikeOperations aerospikeOperations) {
        return new WalOperations(configuration, aerospikeOperations);
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    protected TransactionalOperations buildTransactionalOperations(Supplier<WriteAheadLogManager> writeAheadLogManager, Supplier<LockOperations> lockOperations, Supplier<MutateOperations> mutateOperations) {
        return new TransactionalOperations(writeAheadLogManager.get(), lockOperations.get(), mutateOperations.get());
    }

    protected MutateOperations buildMutateOperations(AerospikeOperations aerospikeOperations) {
        return new BasicMutateOperations(aerospikeOperations);
    }

    protected LockOperations buildLockOperations(AerospikeOperations aerospikeOperations) {
        return new BasicLockOperations(aerospikeOperations);
    }

    protected WriteAheadLogManager buildWriteAheadLogManager(WalOperations walOperations, Clock clock) {
        return new WriteAheadLogManagerBasic(walOperations, clock);
    }

    protected WriteAheadLogCompleter buildWriteAheadLogCompleter(WalOperations walOperations, Supplier<WriteAheadLogManager> writeAheadLogManager, Supplier<LockOperations> lockOperations, Supplier<MutateOperations> mutateOperations) {
        return new WriteAheadLogCompleter(walOperations, this.buildWalCompleterTransactionalOperations(writeAheadLogManager, lockOperations, mutateOperations));
    }

    protected TransactionalOperations buildWalCompleterTransactionalOperations(Supplier<WriteAheadLogManager> writeAheadLogManager, Supplier<LockOperations> lockOperations, Supplier<MutateOperations> mutateOperations) {
        return new TransactionalOperations(writeAheadLogManager.get(), lockOperations.get(), mutateOperations.get());
    }

    protected ReadOperations buildReadOperations(Configuration configuration, AerospikeOperations aerospikeOperations) {
        return new ReadOperations(aerospikeOperations, (Integer)configuration.get(ConfigOptions.PARALLEL_READ_THRESHOLD, new String[0]));
    }

    protected ScanOperations buildScanOperations(Configuration configuration, AerospikeOperations aerospikeOperations) {
        Integer scanParallelism = (Integer)configuration.get(ConfigOptions.SCAN_PARALLELISM, new String[0]);
        if (scanParallelism > 0) {
            ThreadPoolExecutor scanExecutor = this.buildExecutor(0, scanParallelism, "scan");
            return new BasicScanOperations(aerospikeOperations, scanExecutor);
        }
        return new UnsupportedScanOperations();
    }

    @Override
    public void close() {
        this.writeAheadLogCompleter.shutdown();
        this.scanOperations.close();
        this.aerospikeOperations.close();
    }
}

