/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.operations;

import com.aerospike.client.ScanCallback;
import com.aerospike.client.policy.ScanPolicy;
import com.google.common.util.concurrent.MoreExecutors;
import com.playtika.janusgraph.aerospike.operations.AerospikeKeyIterator;
import com.playtika.janusgraph.aerospike.operations.AerospikeOperations;
import com.playtika.janusgraph.aerospike.operations.ScanOperations;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicScanOperations
implements ScanOperations {
    private static Logger logger = LoggerFactory.getLogger(BasicScanOperations.class);
    private final AerospikeOperations aerospikeOperations;
    private final ScanPolicy scanPolicy;
    private final ExecutorService scanExecutor;

    public BasicScanOperations(AerospikeOperations aerospikeOperations, ExecutorService scanExecutor) {
        this.aerospikeOperations = aerospikeOperations;
        this.scanPolicy = aerospikeOperations.getAerospikePolicyProvider().scanPolicy();
        this.scanExecutor = scanExecutor;
    }

    @Override
    public KeyIterator getKeys(String storeName, SliceQuery query, StoreTransaction txh) {
        logger.warn("Running scan operation storeName=[{}], query=[{}], tx=[{}]", new Object[]{storeName, query, txh});
        if (logger.isTraceEnabled()) {
            logger.trace("Running scan operation stacktrace:\n{}", (Object)Stream.of(Thread.currentThread().getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n")));
        }
        AerospikeKeyIterator keyIterator = new AerospikeKeyIterator(query);
        this.scanExecutor.execute(() -> {
            try {
                this.aerospikeOperations.getClient().scanAll(this.scanPolicy, this.aerospikeOperations.getNamespace(), this.aerospikeOperations.getSetName(storeName), (ScanCallback)keyIterator, new String[0]);
                logger.info("Finished scan operation storeName=[{}], query=[{}], tx=[{}]", new Object[]{storeName, query, txh});
            }
            catch (Throwable t) {
                logger.error("Error while running scan operation storeName=[{}], query=[{}], tx=[{}]", new Object[]{storeName, query, txh, t});
                throw t;
            }
            finally {
                keyIterator.close();
            }
        });
        return keyIterator;
    }

    @Override
    public void close() {
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.scanExecutor, (long)4L, (TimeUnit)TimeUnit.SECONDS);
    }
}

