/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.transaction;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.playtika.janusgraph.aerospike.operations.LockOperations;
import com.playtika.janusgraph.aerospike.operations.MutateOperations;
import com.playtika.janusgraph.aerospike.transaction.WriteAheadLogManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.PermanentBackendException;

public class TransactionalOperations {
    private final WriteAheadLogManager writeAheadLogManager;
    private final LockOperations lockOperations;
    private final MutateOperations mutateOperations;

    public TransactionalOperations(WriteAheadLogManager writeAheadLogManager, LockOperations lockOperations, MutateOperations mutateOperations) {
        this.writeAheadLogManager = writeAheadLogManager;
        this.lockOperations = lockOperations;
        this.mutateOperations = mutateOperations;
    }

    public void mutateTransactionally(Map<String, Map<Value, Map<Value, Value>>> locksByStore, Map<String, Map<Value, Map<Value, Value>>> mutationsByStore) throws BackendException {
        Value transactionId = this.writeAheadLogManager.writeTransaction(locksByStore, mutationsByStore);
        this.processAndDeleteTransaction(transactionId, locksByStore, mutationsByStore, false);
    }

    void processAndDeleteTransaction(Value transactionId, Map<String, Map<Value, Map<Value, Value>>> locksByStore, Map<String, Map<Value, Map<Value, Value>>> mutationsByStore, boolean wal) throws BackendException {
        Set<Key> keysLocked = this.lockOperations.acquireLocks(transactionId, locksByStore, wal, lockKeys -> this.releaseLocksAndDeleteWalTransactionOnError((Collection<Key>)lockKeys, transactionId));
        try {
            this.mutateOperations.mutateMany(mutationsByStore, wal);
            this.releaseLocksAndDeleteWalTransaction(keysLocked, transactionId);
        }
        catch (AerospikeException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    private void releaseLocksAndDeleteWalTransaction(Collection<Key> keysLocked, Value transactionId) {
        this.lockOperations.releaseLocks(keysLocked, transactionId);
        this.writeAheadLogManager.deleteTransaction(transactionId);
    }

    void releaseLocksAndDeleteWalTransactionOnError(Collection<Key> lockKeys, Value transactionId) {
        List<Key> transactionLockKeys = this.lockOperations.filterKeysLockedByTransaction(lockKeys, transactionId);
        this.releaseLocksAndDeleteWalTransaction(transactionLockKeys, transactionId);
    }

    void releaseLocksAndDeleteWalTransactionOnError(Map<String, Map<Value, Map<Value, Value>>> locksByStore, Value transactionId) {
        List<Key> transactionLockKeys = this.lockOperations.filterKeysLockedByTransaction(locksByStore, transactionId);
        this.releaseLocksAndDeleteWalTransaction(transactionLockKeys, transactionId);
    }

    public WriteAheadLogManager getWriteAheadLogManager() {
        return this.writeAheadLogManager;
    }

    public MutateOperations getMutateOperations() {
        return this.mutateOperations;
    }
}

