/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike;

import com.aerospike.client.Value;
import com.playtika.janusgraph.aerospike.AerospikeTransaction;
import com.playtika.janusgraph.aerospike.DeferredLock;
import com.playtika.janusgraph.aerospike.operations.AerospikeOperations;
import com.playtika.janusgraph.aerospike.operations.ErrorMapper;
import com.playtika.janusgraph.aerospike.operations.IdsCleanupOperations;
import com.playtika.janusgraph.aerospike.operations.MutateOperations;
import com.playtika.janusgraph.aerospike.operations.ReadOperations;
import com.playtika.janusgraph.aerospike.operations.ScanOperations;
import com.playtika.janusgraph.aerospike.operations.batch.BatchLocks;
import com.playtika.janusgraph.aerospike.operations.batch.BatchUpdate;
import com.playtika.janusgraph.aerospike.operations.batch.BatchUpdates;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nosql.batch.update.BatchUpdater;
import nosql.batch.update.aerospike.lock.AerospikeLock;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRangeQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AerospikeKeyColumnValueStore
implements KeyColumnValueStore {
    private static final Logger logger = LoggerFactory.getLogger(AerospikeKeyColumnValueStore.class);
    private final String storeName;
    private final ReadOperations readOperations;
    private final AerospikeOperations aerospikeOperations;
    private final BatchUpdater<BatchLocks, BatchUpdates, AerospikeLock, Value> batchUpdater;
    private final MutateOperations mutateOperations;
    private final ScanOperations scanOperations;
    private final IdsCleanupOperations idsCleanupOperations;

    protected AerospikeKeyColumnValueStore(String storeName, ReadOperations readOperations, AerospikeOperations aerospikeOperations, BatchUpdater<BatchLocks, BatchUpdates, AerospikeLock, Value> batchUpdater, MutateOperations mutateOperations, ScanOperations scanOperations, IdsCleanupOperations idsCleanupOperations) {
        this.storeName = storeName;
        this.readOperations = readOperations;
        this.aerospikeOperations = aerospikeOperations;
        this.batchUpdater = batchUpdater;
        this.mutateOperations = mutateOperations;
        this.scanOperations = scanOperations;
        this.idsCleanupOperations = idsCleanupOperations;
    }

    public KeyIterator getKeys(KeyRangeQuery query, StoreTransaction txh) {
        throw new UnsupportedOperationException();
    }

    public KeyIterator getKeys(SliceQuery query, StoreTransaction txh) {
        logger.trace("getKeys({}, tx:{}, {})", new Object[]{this.storeName, txh, query});
        return this.scanOperations.getKeys(this.storeName, query, txh);
    }

    public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        logger.trace("getSlice({}, tx:{}, {}, start:{}, end:{})", new Object[]{this.storeName, txh, keys, query.getSliceStart(), query.getSliceEnd()});
        return this.readOperations.getSlice(this.storeName, keys, query);
    }

    public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws BackendException {
        logger.trace("getSlice({}, tx:{}, {})", new Object[]{this.storeName, txh, query});
        return this.readOperations.getSlice(this.storeName, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws BackendException {
        logger.trace("mutate({}, tx:{}, {}, {}, {})", new Object[]{this.storeName, txh, key, additions, deletions});
        AerospikeTransaction transaction = (AerospikeTransaction)txh;
        Map<Value, Value> mutationMap = AerospikeKeyColumnValueStore.mutationToMap(new KCVMutation(additions, deletions));
        Value keyValue = AerospikeOperations.getValue(key);
        try {
            if (transaction.getLocks().isEmpty()) {
                this.mutateOperations.mutate(this.storeName, keyValue, mutationMap);
            } else {
                this.updateBatch(keyValue, mutationMap, transaction);
            }
        }
        finally {
            if (this.idsCleanupOperations != null) {
                this.idsCleanupOperations.cleanUpOldIdsRanges(key);
            }
        }
    }

    private void updateBatch(Value keyValue, Map<Value, Value> mutationMap, AerospikeTransaction transaction) throws BackendException {
        Map<String, Map<Value, Map<Value, Value>>> locksByStore = transaction.getLocksByStoreKeyColumn();
        if (!Collections.singleton(this.storeName).containsAll(locksByStore.keySet())) {
            throw new IllegalArgumentException();
        }
        Map locks = locksByStore.getOrDefault(this.storeName, Collections.emptyMap());
        if (!Collections.singleton(keyValue).containsAll(locks.keySet())) {
            throw new IllegalArgumentException();
        }
        Map<String, Map<Value, Map<Value, Value>>> mutationsByStore = Collections.singletonMap(this.storeName, Collections.singletonMap(keyValue, mutationMap));
        try {
            this.batchUpdater.update((nosql.batch.update.BatchUpdate)new BatchUpdate(new BatchLocks(locksByStore, this.aerospikeOperations), new BatchUpdates(mutationsByStore)));
        }
        catch (Throwable t) {
            throw ErrorMapper.INSTANCE.apply(t);
        }
        transaction.close();
    }

    public static Map<Value, Value> mutationToMap(KCVMutation mutation) {
        HashMap<Value, Value> map = new HashMap<Value, Value>(mutation.getAdditions().size() + mutation.getDeletions().size());
        for (StaticBuffer deletion : mutation.getDeletions()) {
            map.put(AerospikeOperations.getValue(deletion), Value.NULL);
        }
        for (Entry addition : mutation.getAdditions()) {
            map.put(AerospikeOperations.getValue(addition.getColumn()), AerospikeOperations.getValue(addition.getValue()));
        }
        return map;
    }

    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) {
        ((AerospikeTransaction)txh).addLock(new DeferredLock(this.storeName, key, column, expectedValue));
        logger.trace("registered lock: {}:{}:{}:{}, tx:{}", new Object[]{this.storeName, key, column, expectedValue, txh});
    }

    public synchronized void close() {
    }

    public String getName() {
        return this.storeName;
    }
}

