/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike;

import com.aerospike.client.async.EventLoops;
import com.aerospike.client.async.NettyEventLoops;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.playtika.janusgraph.aerospike.ConfigOptions;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;

public class AerospikePolicyProvider {
    public static final int NO_RETRIES = 0;
    private final Configuration configuration;
    private EventLoops eventLoops;

    public AerospikePolicyProvider(Configuration configuration) {
        this.configuration = configuration;
    }

    public ClientPolicy clientPolicy() {
        ClientPolicy clientPolicy = new ClientPolicy();
        clientPolicy.user = this.configuration.has(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0]) ? (String)this.configuration.get(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0]) : null;
        clientPolicy.password = this.configuration.has(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0]) ? (String)this.configuration.get(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0]) : null;
        clientPolicy.minConnsPerNode = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_MIN_CONNECTIONS_PER_NODE, new String[0]);
        clientPolicy.maxConnsPerNode = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_CONNECTIONS_PER_NODE, new String[0]);
        clientPolicy.readPolicyDefault = this.readPolicy();
        clientPolicy.scanPolicyDefault = this.scanPolicy();
        clientPolicy.queryPolicyDefault = this.queryPolicy();
        clientPolicy.writePolicyDefault = this.writePolicy();
        clientPolicy.batchPolicyDefault = this.batchPolicy();
        clientPolicy.eventLoops = this.eventLoops();
        return clientPolicy;
    }

    public BatchPolicy batchPolicy() {
        BatchPolicy batchPolicy = new BatchPolicy();
        batchPolicy.totalTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_WRITE_TIMEOUT, new String[0]);
        batchPolicy.socketTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_SOCKET_TIMEOUT, new String[0]);
        return batchPolicy;
    }

    public QueryPolicy queryPolicy() {
        QueryPolicy queryPolicy = new QueryPolicy();
        queryPolicy.totalTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_READ_TIMEOUT, new String[0]);
        queryPolicy.socketTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_SOCKET_TIMEOUT, new String[0]);
        queryPolicy.maxRetries = 0;
        return queryPolicy;
    }

    public WritePolicy writePolicy() {
        WritePolicy writePolicy = new WritePolicy();
        writePolicy.sendKey = true;
        writePolicy.expiration = -1;
        writePolicy.totalTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_WRITE_TIMEOUT, new String[0]);
        writePolicy.socketTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_SOCKET_TIMEOUT, new String[0]);
        writePolicy.maxRetries = 0;
        return writePolicy;
    }

    public WritePolicy deletePolicy() {
        WritePolicy deletePolicy = new WritePolicy();
        deletePolicy.expiration = -1;
        deletePolicy.totalTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_WRITE_TIMEOUT, new String[0]);
        deletePolicy.socketTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_SOCKET_TIMEOUT, new String[0]);
        deletePolicy.durableDelete = (Boolean)this.configuration.get(ConfigOptions.TEST_ENVIRONMENT, new String[0]) == false;
        deletePolicy.maxRetries = 0;
        return deletePolicy;
    }

    public Policy readPolicy() {
        Policy readPolicy = new Policy();
        readPolicy.sendKey = true;
        readPolicy.totalTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_READ_TIMEOUT, new String[0]);
        readPolicy.socketTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_SOCKET_TIMEOUT, new String[0]);
        readPolicy.maxRetries = 0;
        return readPolicy;
    }

    public ScanPolicy scanPolicy() {
        ScanPolicy scanPolicy = new ScanPolicy();
        scanPolicy.sendKey = true;
        scanPolicy.includeBinData = true;
        scanPolicy.socketTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_SOCKET_TIMEOUT, new String[0]);
        scanPolicy.totalTimeout = (Integer)this.configuration.get(ConfigOptions.AEROSPIKE_READ_TIMEOUT, new String[0]);
        return scanPolicy;
    }

    public EventLoops eventLoops() {
        if (this.eventLoops == null) {
            this.eventLoops = new NettyEventLoops((EventLoopGroup)new NioEventLoopGroup());
        }
        return this.eventLoops;
    }

    public void close() {
        this.eventLoops.close();
    }
}

