/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike;

import com.aerospike.client.Value;
import com.playtika.janusgraph.aerospike.DeferredLock;
import com.playtika.janusgraph.aerospike.operations.AerospikeOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.common.AbstractStoreTransaction;

final class AerospikeTransaction
extends AbstractStoreTransaction {
    private List<DeferredLock> locks = new ArrayList<DeferredLock>();

    AerospikeTransaction(BaseTransactionConfig config) {
        super(config);
    }

    public void commit() {
        this.close();
    }

    public void rollback() {
        this.locks.clear();
    }

    public void close() {
        this.locks = null;
    }

    void addLock(DeferredLock lock) {
        this.locks.add(lock);
    }

    List<DeferredLock> getLocks() {
        return this.locks;
    }

    Map<String, Map<Value, Map<Value, Value>>> getLocksByStoreKeyColumn() {
        return this.locks.stream().collect(Collectors.groupingBy(lock -> lock.storeName, Collectors.groupingBy(lock -> AerospikeOperations.getValue(lock.key), Collectors.toMap(lock -> AerospikeOperations.getValue(lock.column), lock -> lock.expectedValue != null ? AerospikeOperations.getValue(lock.expectedValue) : Value.NULL, (oldValue, newValue) -> oldValue))));
    }

    public String toString() {
        return Integer.toHexString(((Object)((Object)this)).hashCode());
    }
}

