/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.operations;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.Host;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.client.policy.ClientPolicy;
import com.playtika.janusgraph.aerospike.AerospikePolicyProvider;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import nosql.batch.update.util.AsyncUtil;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AerospikeOperations {
    private static final Logger logger = LoggerFactory.getLogger(AerospikeOperations.class);
    private static final int DEFAULT_PORT = 3000;
    public static final String ENTRIES_BIN_NAME = "entries";
    private final String namespace;
    private final String idsNamespace;
    private final String idsStoreName;
    private final String graphPrefix;
    private final IAerospikeClient client;
    private final ExecutorService aerospikeExecutor;
    private final AerospikePolicyProvider aerospikePolicyProvider;
    private final ExecutorService batchExecutor;
    private final ScheduledExecutorService statsLogger;
    private final ScheduledFuture<?> statsFuture;

    public AerospikeOperations(String graphPrefix, String namespace, String idsNamespace, String idsStoreName, IAerospikeClient client, AerospikePolicyProvider aerospikePolicyProvider, ExecutorService aerospikeExecutor, ExecutorService batchExecutor) {
        this.graphPrefix = graphPrefix + ".";
        this.namespace = namespace;
        this.idsNamespace = idsNamespace;
        this.idsStoreName = idsStoreName;
        this.client = client;
        this.aerospikeExecutor = aerospikeExecutor;
        this.aerospikePolicyProvider = aerospikePolicyProvider;
        this.batchExecutor = batchExecutor;
        this.statsLogger = Executors.newScheduledThreadPool(1);
        this.statsFuture = this.statsLogger.scheduleAtFixedRate(() -> Stream.of(client.getCluster().getNodes()).forEach(node -> logger.info("node [{}] connections stats: {}", node, (Object)node.getConnectionStats())), 5L, 5L, TimeUnit.MINUTES);
    }

    public IAerospikeClient getClient() {
        return this.client;
    }

    public ExecutorService getAerospikeExecutor() {
        return this.aerospikeExecutor;
    }

    public ExecutorService getBatchExecutor() {
        return this.batchExecutor;
    }

    public String getNamespace() {
        return this.namespace;
    }

    Key getKey(String storeName, StaticBuffer staticBuffer) {
        return this.getKey(storeName, AerospikeOperations.getValue(staticBuffer));
    }

    public static Value getValue(StaticBuffer staticBuffer) {
        return (Value)staticBuffer.as((array, offset, limit) -> Value.get((byte[])array, (int)offset, (int)(limit - offset)));
    }

    public Key getKey(String storeName, Value value) {
        String namespace = this.idsStoreName.equals(storeName) ? this.idsNamespace : this.namespace;
        return new Key(namespace, this.getSetName(storeName), value);
    }

    String getSetName(String storeName) {
        return this.graphPrefix + storeName;
    }

    public AerospikePolicyProvider getAerospikePolicyProvider() {
        return this.aerospikePolicyProvider;
    }

    public String getGraphPrefix() {
        return this.graphPrefix;
    }

    public void close() {
        this.statsFuture.cancel(true);
        AsyncUtil.shutdownAndAwaitTermination((ExecutorService)this.statsLogger);
        this.client.close();
        this.aerospikePolicyProvider.close();
    }

    public static IAerospikeClient buildAerospikeClient(Configuration configuration, ClientPolicy clientPolicy) {
        int port = configuration.has(GraphDatabaseConfiguration.STORAGE_PORT, new String[0]) ? (Integer)configuration.get(GraphDatabaseConfiguration.STORAGE_PORT, new String[0]) : 3000;
        Host[] hosts = (Host[])Stream.of((String[])configuration.get(GraphDatabaseConfiguration.STORAGE_HOSTS, new String[0])).map(hostname -> new Host(hostname, port)).toArray(Host[]::new);
        return new AerospikeClient(clientPolicy, hosts);
    }
}

