/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.janusgraph.diskstorage.PermanentBackendException;

public class AsyncUtil {
    public static final int WAIT_TIMEOUT_IN_SECONDS = 4;

    public static <K, E extends Exception> void completeAll(Collection<K> keys, Predicate<K> keyPredicate, Function<K, Boolean> resultFunction, Supplier<E> failedResultErrorSupplier, Executor executor) throws E {
        if (keys.isEmpty()) {
            return;
        }
        if (keys.size() == 1) {
            K key = keys.iterator().next();
            if (!keyPredicate.test(key)) {
                return;
            }
            boolean result = resultFunction.apply(key);
            if (!result && failedResultErrorSupplier != null) {
                throw (Exception)failedResultErrorSupplier.get();
            }
            return;
        }
        ArrayList futures = new ArrayList(keys.size());
        AtomicReference failed = new AtomicReference();
        AtomicBoolean checkFailed = new AtomicBoolean(false);
        for (Object key : keys) {
            if (!keyPredicate.test(key)) continue;
            futures.add(CompletableFuture.runAsync(() -> {
                if (checkFailed.get()) {
                    return;
                }
                try {
                    if (!((Boolean)resultFunction.apply(key)).booleanValue()) {
                        checkFailed.set(true);
                    }
                }
                catch (Throwable t) {
                    failed.set(t);
                    checkFailed.set(true);
                }
            }, executor));
        }
        AsyncUtil.completeAll(futures);
        if (failed.get() != null) {
            throw new RuntimeException((Throwable)failed.get());
        }
        if (checkFailed.get() && failedResultErrorSupplier != null) {
            throw (Exception)failedResultErrorSupplier.get();
        }
    }

    protected static void completeAll(List<CompletableFuture<?>> futures) {
        try {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, V> Map<K, V> mapAll(Collection<K> keys, Function<K, V> valueFunction, Executor executor) throws PermanentBackendException {
        if (keys.size() == 1) {
            K key = keys.iterator().next();
            return Collections.singletonMap(key, valueFunction.apply(key));
        }
        HashMap<K, CompletableFuture<Object>> futures = new HashMap<K, CompletableFuture<Object>>(keys.size());
        AtomicReference failed = new AtomicReference();
        for (Object key : keys) {
            futures.put(key, CompletableFuture.supplyAsync(() -> {
                try {
                    if (failed.get() != null) {
                        return null;
                    }
                    return valueFunction.apply(key);
                }
                catch (Throwable t) {
                    failed.set(t);
                    return null;
                }
            }, executor));
        }
        Map result = AsyncUtil.getAll(futures);
        if (failed.get() != null) {
            throw new PermanentBackendException((Throwable)failed.get());
        }
        return result;
    }

    public static <K, V> Map<K, V> getAll(Map<K, CompletableFuture<V>> futureMap) throws PermanentBackendException {
        HashMap<K, V> resultMap = new HashMap<K, V>(futureMap.size());
        try {
            for (Map.Entry<K, CompletableFuture<V>> entry : futureMap.entrySet()) {
                resultMap.put(entry.getKey(), entry.getValue().get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return resultMap;
    }
}

