/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.operations;

import com.aerospike.client.Value;
import com.playtika.janusgraph.aerospike.AerospikeKeyColumnValueStore;
import com.playtika.janusgraph.aerospike.operations.AerospikeOperations;
import com.playtika.janusgraph.aerospike.operations.MutateOperations;
import com.playtika.janusgraph.aerospike.operations.ReadOperations;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdsCleanupOperations {
    private static final Logger logger = LoggerFactory.getLogger(IdsCleanupOperations.class);
    public static final StaticBuffer LOWER_SLICE = BufferUtil.zeroBuffer((int)1);
    public static final StaticBuffer UPPER_SLICE = BufferUtil.oneBuffer((int)17);
    public static final int PROTECTED_BLOCKS_AMOUNT = 10;
    private final String idsStoreName;
    private final long ttl;
    private final ReadOperations readOperations;
    private final MutateOperations mutateOperations;
    private final TimestampProvider timestampProvider;
    private final ExecutorService executorService;
    BlockTimestampComparator TIMESTAMP_COMPARATOR = new BlockTimestampComparator();

    public IdsCleanupOperations(String idsStoreName, ReadOperations readOperations, MutateOperations mutateOperations, long ttl, TimestampProvider timestampProvider, ExecutorService executorService) {
        this.idsStoreName = idsStoreName;
        this.ttl = ttl;
        this.readOperations = readOperations;
        this.mutateOperations = mutateOperations;
        this.timestampProvider = timestampProvider;
        this.executorService = executorService;
    }

    public void cleanUpOldIdsRanges(StaticBuffer key) {
        this.executorService.submit(() -> {
            try {
                this.cleanUpOldIdsRangesImpl(key);
            }
            catch (BackendException e) {
                logger.error("Error while running cleanup of old ranges for key=[{}]", (Object)key, (Object)e);
            }
        });
    }

    public void cleanUpOldIdsRangesImpl(StaticBuffer key) throws BackendException {
        if (this.ttl == Long.MAX_VALUE) {
            return;
        }
        Map<StaticBuffer, EntryList> allIdBlocksMap = this.readOperations.getSlice(this.idsStoreName, Collections.singletonList(key), new SliceQuery(LOWER_SLICE, UPPER_SLICE));
        EntryList blocks = allIdBlocksMap.get(key);
        blocks.sort((Comparator)this.TIMESTAMP_COMPARATOR);
        List blocksToCheck = blocks.subList(0, Math.max(blocks.size() - 10, 0));
        ArrayList<StaticBuffer> columnsToRemove = new ArrayList<StaticBuffer>();
        for (Entry e : blocksToCheck) {
            ByteBuffer byteBuffer = e.asByteBuffer();
            long counterVal = byteBuffer.getLong();
            long idBlockTimestamp = byteBuffer.getLong();
            byte[] instanceNameData = new byte[byteBuffer.remaining()];
            byteBuffer.get(instanceNameData);
            String instanceName = new String(instanceNameData);
            long currentTimestamp = this.timestampProvider.getTime(this.timestampProvider.getTime());
            long ttlTimestamp = this.timestampProvider.getTime(Instant.ofEpochMilli(this.ttl));
            if (idBlockTimestamp < currentTimestamp - ttlTimestamp) {
                columnsToRemove.add(e.getColumn());
                logger.info("Added for removal id block - key=[{}], value=[{}], timestamp=[{}], instanceName=[{}]", new Object[]{key, counterVal, idBlockTimestamp, instanceName});
                continue;
            }
            logger.trace("Will retain id block - key=[{}], value=[{}], timestamp=[{}], instanceName=[{}]", new Object[]{key, counterVal, idBlockTimestamp, instanceName});
        }
        if (!columnsToRemove.isEmpty()) {
            Map<Value, Value> mutationMap = AerospikeKeyColumnValueStore.mutationToMap(new KCVMutation(KeyColumnValueStore.NO_ADDITIONS, columnsToRemove));
            this.mutateOperations.mutate(this.idsStoreName, AerospikeOperations.getValue(key), mutationMap);
            logger.info("Removed [{}] old id blocks for - key=[{}]", (Object)columnsToRemove.size(), (Object)key);
        }
    }

    public String getIdsStoreName() {
        return this.idsStoreName;
    }

    private static long getTimestamp(Entry e) {
        ByteBuffer byteBuffer = e.asByteBuffer();
        byteBuffer.getLong();
        return byteBuffer.getLong();
    }

    private static class BlockTimestampComparator
    implements Comparator<Entry> {
        private BlockTimestampComparator() {
        }

        @Override
        public int compare(Entry e1, Entry e2) {
            return Long.compare(IdsCleanupOperations.getTimestamp(e1), IdsCleanupOperations.getTimestamp(e2));
        }
    }
}

