/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public NamedThreadFactory(String groupName, String prefix) {
        SecurityManager s = System.getSecurityManager();
        ThreadGroup parent = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.group = new ThreadGroup(parent, groupName);
        this.namePrefix = groupName + "-" + prefix + "-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

