/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.trace;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphManagerUtility;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.cache.KCVSCache;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.builder.GraphDatabaseConfigurationBuilder;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.management.JanusGraphManager;
import org.janusgraph.graphdb.relations.EdgeDirection;
import org.janusgraph.graphdb.tinkerpop.optimize.AdjacentVertexFilterOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.AdjacentVertexHasIdOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.AdjacentVertexIsOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphIoRegistrationStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphLocalQueryOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphStepStrategy;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.TypeInspector;
import org.janusgraph.graphdb.types.system.BaseRelationType;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugJanusGraph
extends StandardJanusGraph {
    private static final Logger log = LoggerFactory.getLogger(DebugJanusGraph.class);
    private static final Predicate<InternalRelation> SCHEMA_FILTER = internalRelation -> internalRelation.getType() instanceof BaseRelationType && internalRelation.getVertex(0) instanceof JanusGraphSchemaVertex;
    private static final Predicate<InternalRelation> NO_SCHEMA_FILTER = internalRelation -> !SCHEMA_FILTER.apply(internalRelation);

    public DebugJanusGraph(GraphDatabaseConfiguration configuration) {
        super(configuration);
    }

    public void commit(Collection<InternalRelation> addedRelations, Collection<InternalRelation> deletedRelations, StandardJanusGraphTx tx) {
        super.commit(addedRelations, deletedRelations, tx);
        this.traceCommit(addedRelations, deletedRelations, NO_SCHEMA_FILTER, tx);
    }

    private void traceCommit(Collection<InternalRelation> addedRelations, Collection<InternalRelation> deletedRelations, Predicate<InternalRelation> filter, StandardJanusGraphTx tx) {
        CompositeIndexType iIndex;
        Object lockKey;
        Entry entry;
        InternalVertex vertex;
        boolean acquireLocks = tx.getConfiguration().hasAcquireLocks();
        ArrayListMultimap mutations = ArrayListMultimap.create();
        ArrayListMultimap mutatedProperties = ArrayListMultimap.create();
        ArrayList indexUpdates = Lists.newArrayList();
        for (InternalRelation del : Iterables.filter(deletedRelations, filter)) {
            Preconditions.checkArgument((boolean)del.isRemoved());
            for (int pos = 0; pos < del.getLen(); ++pos) {
                vertex = del.getVertex(pos);
                if (pos == 0 || !del.isLoop()) {
                    if (del.isProperty()) {
                        mutatedProperties.put((Object)vertex, (Object)del);
                    }
                    mutations.put((Object)vertex.longId(), (Object)del);
                }
                if (!DebugJanusGraph.acquireLock((InternalRelation)del, (int)pos, (boolean)acquireLocks)) continue;
                entry = this.edgeSerializer.writeRelation(del, pos, (TypeInspector)tx);
                lockKey = this.getIDManager().getKey(vertex.longId());
                this.traceDeletedEdgeAcquireLock(del, pos, vertex, entry, (StaticBuffer)lockKey);
            }
            Collection delIndexUpdates = this.indexSerializer.getIndexUpdates(del);
            this.traceDeletedEdgeToIndexUpdates(del, delIndexUpdates);
            indexUpdates.addAll(delIndexUpdates);
        }
        for (InternalRelation add : Iterables.filter(addedRelations, filter)) {
            Preconditions.checkArgument((boolean)add.isNew());
            for (int pos = 0; pos < add.getLen(); ++pos) {
                vertex = add.getVertex(pos);
                if (pos == 0 || !add.isLoop()) {
                    if (add.isProperty()) {
                        mutatedProperties.put((Object)vertex, (Object)add);
                    }
                    mutations.put((Object)vertex.longId(), (Object)add);
                }
                if (vertex.isNew() || !DebugJanusGraph.acquireLock((InternalRelation)add, (int)pos, (boolean)acquireLocks)) continue;
                entry = this.edgeSerializer.writeRelation(add, pos, (TypeInspector)tx);
                lockKey = this.getIDManager().getKey(vertex.longId());
                this.traceAddedEdgeAcquireLock(add, pos, vertex, entry, (StaticBuffer)lockKey);
            }
            Collection addIndexUpdates = this.indexSerializer.getIndexUpdates(add);
            this.traceAddedEdgeToIndexUpdates(add, addIndexUpdates);
            indexUpdates.addAll(addIndexUpdates);
        }
        for (InternalVertex v : mutatedProperties.keySet()) {
            List updatedProperties = mutatedProperties.get((Object)v);
            this.traceUpdatedProperties(updatedProperties);
            Collection propertiesIndexUpdates = this.indexSerializer.getIndexUpdates(v, (Collection)updatedProperties);
            this.traceUpdatedPropertiesIndexUpdates(propertiesIndexUpdates);
            indexUpdates.addAll(propertiesIndexUpdates);
        }
        for (IndexSerializer.IndexUpdate update : indexUpdates) {
            if (!update.isCompositeIndex() || !update.isDeletion() || !DebugJanusGraph.acquireLock((CompositeIndexType)(iIndex = (CompositeIndexType)update.getIndex()), (boolean)acquireLocks)) continue;
            this.traceDeletedIndexAcquireLock(update);
        }
        for (IndexSerializer.IndexUpdate update : indexUpdates) {
            if (!update.isCompositeIndex() || !update.isAddition() || !DebugJanusGraph.acquireLock((CompositeIndexType)(iIndex = (CompositeIndexType)update.getIndex()), (boolean)acquireLocks)) continue;
            this.traceAddedIndexAcquireLock(update);
        }
        for (Long vertexId : mutations.keySet()) {
            Preconditions.checkArgument((vertexId > 0L ? 1 : 0) != 0, (String)"Vertex has no id: %s", (Object[])new Object[]{vertexId});
            List edges = mutations.get((Object)vertexId);
            ArrayList<Entry> additions = new ArrayList<Entry>(edges.size());
            ArrayList<Entry> deletions = new ArrayList<Entry>(Math.max(10, edges.size() / 10));
            for (InternalRelation edge : edges) {
                InternalRelationType baseType = (InternalRelationType)edge.getType();
                assert (baseType.getBaseType() == null);
                for (InternalRelationType type : baseType.getRelationIndexes()) {
                    if (type.getStatus() == SchemaStatus.DISABLED) continue;
                    for (int pos = 0; pos < edge.getArity(); ++pos) {
                        if (!type.isUnidirected(Direction.BOTH) && !type.isUnidirected(EdgeDirection.fromPosition((int)pos)) || edge.getVertex(pos).longId() != vertexId.longValue()) continue;
                        StaticArrayEntry entry2 = this.edgeSerializer.writeRelation(edge, type, pos, (TypeInspector)tx);
                        if (edge.isRemoved()) {
                            deletions.add((Entry)entry2);
                            continue;
                        }
                        Preconditions.checkArgument((boolean)edge.isNew());
                        int ttl = DebugJanusGraph.getTTL((InternalRelation)edge);
                        if (ttl > 0) {
                            entry2.setMetaData(EntryMetaData.TTL, (Object)ttl);
                        }
                        additions.add((Entry)entry2);
                    }
                }
            }
            StaticBuffer vertexKey = this.getIDManager().getKey(vertexId.longValue());
            this.traceMutateEdges(vertexId, additions, deletions, vertexKey);
        }
        for (IndexSerializer.IndexUpdate indexUpdate : indexUpdates) {
            assert (indexUpdate.isAddition() || indexUpdate.isDeletion());
            if (!indexUpdate.isCompositeIndex()) continue;
            IndexSerializer.IndexUpdate update = indexUpdate;
            if (update.isAddition()) {
                this.traceAddedIndex((IndexSerializer.IndexUpdate<StaticBuffer, Entry>)update);
                continue;
            }
            this.traceRemovedIndex((IndexSerializer.IndexUpdate<StaticBuffer, Entry>)update);
        }
    }

    private void traceRemovedIndex(IndexSerializer.IndexUpdate<StaticBuffer, Entry> update) {
        log.trace("Will mutateIndex removal key: {}, additions: {}, deletions: {}", new Object[]{update.getKey(), KeyColumnValueStore.NO_ADDITIONS, Lists.newArrayList((Object[])new Entry[]{(Entry)update.getEntry()})});
    }

    private void traceAddedIndex(IndexSerializer.IndexUpdate<StaticBuffer, Entry> update) {
        log.trace("Will mutateIndex addition key: {}, additions: {}, deletions: {}", new Object[]{update.getKey(), Lists.newArrayList((Object[])new Entry[]{(Entry)update.getEntry()}), KCVSCache.NO_DELETIONS});
    }

    private void traceMutateEdges(Long vertexId, List<Entry> additions, List<Entry> deletions, StaticBuffer vertexKey) {
        log.trace("Will mutateEdges vertexId:{}, vertexKey: {}, additions: {}, deletions: {}", new Object[]{vertexId, vertexKey, additions, deletions});
    }

    private void traceAddedIndexAcquireLock(IndexSerializer.IndexUpdate update) {
        log.trace("Will acquireIndexLock added key: {}, column: {}, index: {}", new Object[]{update.getKey(), ((Entry)update.getEntry()).getColumn(), update.getIndex()});
    }

    private void traceDeletedIndexAcquireLock(IndexSerializer.IndexUpdate update) {
        log.trace("Will acquireIndexLock deleted key: {}, entry: {}, element: {}, index: {}", new Object[]{update.getKey(), update.getEntry(), update.getElement(), update.getIndex()});
    }

    private void traceUpdatedPropertiesIndexUpdates(Collection<IndexSerializer.IndexUpdate> propertiesIndexUpdates) {
        propertiesIndexUpdates.forEach(indexUpdate -> log.trace("Properties updated index update key: {}, entry: {}, element: {}, index: {}", new Object[]{indexUpdate.getKey(), indexUpdate.getEntry(), indexUpdate.getElement(), indexUpdate.getIndex()}));
    }

    private void traceUpdatedProperties(List<InternalRelation> updatedProperties) {
        log.trace("Properties updated index relations: {}", updatedProperties);
    }

    private void traceAddedEdgeToIndexUpdates(InternalRelation add, Collection<IndexSerializer.IndexUpdate> addIndexUpdates) {
        addIndexUpdates.forEach(indexUpdate -> log.trace("Added edge index update relation: {} -> key: {}, entry: {}, element: {}, index: {}", new Object[]{add, indexUpdate.getKey(), indexUpdate.getEntry(), indexUpdate.getElement(), indexUpdate.getIndex()}));
    }

    private void traceAddedEdgeAcquireLock(InternalRelation add, int pos, InternalVertex vertex, Entry entry, StaticBuffer lockKey) {
        log.trace("Will acquireEdgeLock added edge: {}, pos: {}, vertex id: {}, lock key: {}, expected value: {}", new Object[]{add, pos, vertex.longId(), lockKey, entry});
    }

    private void traceDeletedEdgeToIndexUpdates(InternalRelation del, Collection<IndexSerializer.IndexUpdate> delIndexUpdates) {
        delIndexUpdates.forEach(indexUpdate -> log.trace("Removed edge index update relation: {} -> key: {}, entry: {}, element: {}, index: {}", new Object[]{del, indexUpdate.getKey(), indexUpdate.getEntry(), indexUpdate.getElement(), indexUpdate.getIndex()}));
    }

    private void traceDeletedEdgeAcquireLock(InternalRelation del, int pos, InternalVertex vertex, Entry entry, StaticBuffer lockKey) {
        log.trace("Will acquireEdgeLock deleted relation: {}, pos: {}, vertex id: {}, lock key: {}, expected value: {}", new Object[]{del, pos, vertex.longId(), lockKey, entry});
    }

    public static JanusGraph open(ReadConfiguration configuration) {
        ModifiableConfiguration config = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, (WriteConfiguration)configuration, BasicConfiguration.Restriction.NONE);
        String graphName = config.has(GraphDatabaseConfiguration.GRAPH_NAME, new String[0]) ? (String)config.get(GraphDatabaseConfiguration.GRAPH_NAME, new String[0]) : null;
        JanusGraphManager jgm = JanusGraphManagerUtility.getInstance();
        if (null != graphName) {
            Preconditions.checkNotNull((Object)jgm, (Object)"Gremlin Server must be configured to use the JanusGraphManager.");
            return (JanusGraph)jgm.openGraph(graphName, gName -> new DebugJanusGraph(new GraphDatabaseConfigurationBuilder().build(configuration)));
        }
        if (jgm != null) {
            log.warn("You should supply \"graph.graphname\" in your .properties file configuration if you are opening a graph that has not already been opened at server start, i.e. it was defined in your YAML file. This will ensure the graph is tracked by the JanusGraphManager, which will enable autocommit and rollback functionality upon all gremlin script executions. Note that JanusGraphFactory#open(String === shortcut notation) does not support consuming the property \"graph.graphname\" so these graphs should be accessed dynamically by supplying a .properties file here or by using the ConfiguredGraphFactory.");
        }
        return new DebugJanusGraph(new GraphDatabaseConfigurationBuilder().build(configuration));
    }

    static {
        TraversalStrategies graphStrategies = TraversalStrategies.GlobalCache.getStrategies(Graph.class).clone().addStrategies(new TraversalStrategy[]{AdjacentVertexFilterOptimizerStrategy.instance(), AdjacentVertexHasIdOptimizerStrategy.instance(), AdjacentVertexIsOptimizerStrategy.instance(), JanusGraphLocalQueryOptimizerStrategy.instance(), JanusGraphStepStrategy.instance(), JanusGraphIoRegistrationStrategy.instance()});
        TraversalStrategies.GlobalCache.registerStrategies(DebugJanusGraph.class, (TraversalStrategies)graphStrategies);
    }
}

