/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.utility;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.olap.VertexJobConverter;
import org.janusgraph.graphdb.query.vertex.VertexCentricQueryBuilder;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.vertices.CacheVertex;

public class GhostVertexRemover {
    private static final SliceQuery EVERYTHING_QUERY = new SliceQuery(BufferUtil.zeroBuffer((int)1), BufferUtil.oneBuffer((int)4));
    private static final int RELATION_COUNT_LIMIT = 20000;
    private static final SliceQuery EVERYTHING_QUERY_LIMIT = EVERYTHING_QUERY.updateLimit(20000);
    private final IDManager idManager;
    private final KeyColumnValueStore edgeStore;
    private final StandardJanusGraphTx tx;

    public GhostVertexRemover(StandardJanusGraph standardJanusGraph) throws BackendException {
        this.idManager = standardJanusGraph.getIDManager();
        KeyColumnValueStoreManager storeManager = (KeyColumnValueStoreManager)standardJanusGraph.getBackend().getStoreManager();
        this.edgeStore = storeManager.openDatabase("edgestore");
        this.tx = VertexJobConverter.startTransaction((StandardJanusGraph)standardJanusGraph);
    }

    public void removeGhostVertex(long vertexId) throws BackendException {
        StaticBuffer key = this.idManager.getKey(vertexId);
        EntryList entryList = this.edgeStore.getSlice(new KeySliceQuery(key, EVERYTHING_QUERY), (StoreTransaction)new FakeStoreTransaction());
        Map<SliceQuery, EntryList> entries = Collections.singletonMap(EVERYTHING_QUERY, entryList);
        assert (entries.get(EVERYTHING_QUERY_LIMIT) != null);
        EntryList everything = entries.get(EVERYTHING_QUERY_LIMIT);
        InternalVertex vertex = this.tx.getInternalVertex(vertexId);
        Preconditions.checkArgument((boolean)(vertex instanceof CacheVertex), (Object)"The bounding transaction is not configured correctly");
        CacheVertex v = (CacheVertex)vertex;
        v.loadRelations(EVERYTHING_QUERY, input -> everything);
        int removedRelations = 0;
        Iterator iterator = ((VertexCentricQueryBuilder)v.query().noPartitionRestriction()).relations().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            ++removedRelations;
        }
        v.remove();
        this.tx.commit();
    }

    private static class FakeStoreTransaction
    implements StoreTransaction {
        private FakeStoreTransaction() {
        }

        public void commit() {
        }

        public void rollback() {
        }

        public BaseTransactionConfig getConfiguration() {
            return null;
        }
    }
}

