/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.operations;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cdt.MapOperation;
import com.aerospike.client.cdt.MapOrder;
import com.aerospike.client.cdt.MapPolicy;
import com.aerospike.client.cdt.MapWriteMode;
import com.aerospike.client.policy.WritePolicy;
import com.playtika.janusgraph.aerospike.AerospikePolicyProvider;
import com.playtika.janusgraph.aerospike.operations.AerospikeOperations;
import com.playtika.janusgraph.aerospike.operations.MutateOperations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.janusgraph.graphdb.database.idassigner.IDPoolExhaustedException;

public class BasicMutateOperations
implements MutateOperations {
    static final MapPolicy mapPolicy = new MapPolicy(MapOrder.KEY_ORDERED, MapWriteMode.UPDATE);
    private final WritePolicy mutatePolicy;
    private final WritePolicy deletePolicy;
    private final AerospikeOperations aerospikeOperations;

    public BasicMutateOperations(AerospikeOperations aerospikeOperations) {
        this.aerospikeOperations = aerospikeOperations;
        AerospikePolicyProvider aerospikePolicyProvider = aerospikeOperations.getAerospikePolicyProvider();
        this.mutatePolicy = BasicMutateOperations.buildMutationPolicy(aerospikePolicyProvider);
        this.deletePolicy = aerospikePolicyProvider.deletePolicy();
    }

    @Override
    public void mutate(String storeName, Value key, Map<Value, Value> mutation) {
        block10: {
            int entriesNoOperationIndex;
            Key aerospikeKey = this.aerospikeOperations.getKey(storeName, key);
            ArrayList<Operation> operations = new ArrayList<Operation>(3);
            ArrayList<Value> keysToRemove = new ArrayList<Value>(mutation.size());
            HashMap<Value, Value> itemsToAdd = new HashMap<Value, Value>(mutation.size());
            for (Map.Entry<Value, Value> entry : mutation.entrySet()) {
                if (entry.getValue() == Value.NULL) {
                    keysToRemove.add(entry.getKey());
                    continue;
                }
                itemsToAdd.put(entry.getKey(), entry.getValue());
            }
            if (!keysToRemove.isEmpty()) {
                operations.add(MapOperation.removeByKeyList((String)"entries", keysToRemove, (int)0, (CTX[])new CTX[0]));
            }
            if (!itemsToAdd.isEmpty()) {
                operations.add(MapOperation.putItems((MapPolicy)mapPolicy, (String)"entries", itemsToAdd, (CTX[])new CTX[0]));
            }
            if (!keysToRemove.isEmpty()) {
                entriesNoOperationIndex = operations.size();
                operations.add(MapOperation.size((String)"entries", (CTX[])new CTX[0]));
            } else {
                entriesNoOperationIndex = -1;
            }
            IAerospikeClient client = this.aerospikeOperations.getClient();
            try {
                long entriesNoAfterMutation;
                Record record = client.operate(this.mutatePolicy, aerospikeKey, operations.toArray(new Operation[0]));
                if (entriesNoOperationIndex != -1 && (entriesNoAfterMutation = ((Long)record.getList("entries").get(entriesNoOperationIndex)).longValue()) == 0L) {
                    client.delete(this.deletePolicy, aerospikeKey);
                }
            }
            catch (AerospikeException ae) {
                if (ae.getResultCode() == 13 && storeName.equals("janusgraph_ids")) {
                    throw new IDPoolExhaustedException((Throwable)ae);
                }
                if (ae.getResultCode() == 2) break block10;
                throw ae;
            }
        }
    }

    private static WritePolicy buildMutationPolicy(AerospikePolicyProvider policyProvider) {
        WritePolicy mutatePolicy = new WritePolicy(policyProvider.writePolicy());
        mutatePolicy.respondAllOps = true;
        return mutatePolicy;
    }
}

