/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.operations.batch;

import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cdt.MapOperation;
import com.aerospike.client.policy.WritePolicy;
import com.playtika.janusgraph.aerospike.operations.AerospikeOperations;
import com.playtika.janusgraph.aerospike.operations.batch.ExpectedValue;
import com.playtika.janusgraph.aerospike.util.AsyncUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nosql.batch.update.aerospike.lock.AerospikeExpectedValuesOperations;
import nosql.batch.update.aerospike.lock.AerospikeLock;
import nosql.batch.update.lock.Lock;
import nosql.batch.update.lock.PermanentLockingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchExpectedValueOperations
implements AerospikeExpectedValuesOperations<Map<Key, ExpectedValue>> {
    private static final Logger logger = LoggerFactory.getLogger(BatchExpectedValueOperations.class);
    private static final WritePolicy checkValuesPolicy = new WritePolicy();
    private final AerospikeOperations aerospikeOperations;

    public BatchExpectedValueOperations(AerospikeOperations aerospikeOperations) {
        this.aerospikeOperations = aerospikeOperations;
    }

    public void checkExpectedValues(List<AerospikeLock> locks, Map<Key, ExpectedValue> expectedValues) throws PermanentLockingException {
        if (locks.size() != expectedValues.size()) {
            throw new IllegalArgumentException("locks.size() != expectedValues.size()");
        }
        AsyncUtil.completeAll(locks, aerospikeLock -> aerospikeLock.lockType != Lock.LockType.SAME_BATCH, aerospikeLock -> {
            ExpectedValue expectedValue = (ExpectedValue)expectedValues.get(aerospikeLock.key);
            Key keyToCheck = this.aerospikeOperations.getKey(expectedValue.storeName, expectedValue.key);
            return this.checkColumnValues(keyToCheck, expectedValue.values);
        }, () -> new PermanentLockingException("Some values don't match expected values"), this.aerospikeOperations.getAerospikeExecutor());
    }

    private boolean checkColumnValues(Key key, Map<Value, Value> valuesForKey) {
        if (valuesForKey.isEmpty()) {
            throw new IllegalArgumentException(String.format("Empty valuesForKey key=[%s]", key));
        }
        int columnsNo = valuesForKey.size();
        Value[] columns = new Value[columnsNo];
        Operation[] operations = new Operation[columnsNo];
        int i = 0;
        Iterator<Value> iterator = valuesForKey.keySet().iterator();
        while (iterator.hasNext()) {
            Value column;
            columns[i] = column = iterator.next();
            operations[i] = MapOperation.getByKey((String)"entries", (Value)column, (int)7, (CTX[])new CTX[0]);
            ++i;
        }
        try {
            Record record = this.aerospikeOperations.getClient().operate(checkValuesPolicy, key, operations);
            if (record != null) {
                if (columnsNo > 1) {
                    List resultList = record.getList("entries");
                    if (resultList != null) {
                        if (resultList.size() != columnsNo) {
                            throw new IllegalArgumentException(String.format("Unexpected result size [%s] != [%s]", resultList.size(), columnsNo));
                        }
                        for (int j = 0; j < columnsNo; ++j) {
                            Value column = columns[j];
                            if (this.checkValue(key, column, valuesForKey.get(column), (byte[])resultList.get(j))) continue;
                            return false;
                        }
                        return true;
                    }
                    throw new IllegalArgumentException();
                }
                byte[] actualValueData = (byte[])record.getValue("entries");
                Value column = columns[0];
                return this.checkValue(key, column, valuesForKey.get(column), actualValueData);
            }
            return this.allNulls(valuesForKey.values());
        }
        catch (Throwable throwable) {
            logger.error("Error while checkColumnValues for key={}, values={}", new Object[]{key, valuesForKey, throwable});
            throw throwable;
        }
    }

    private boolean allNulls(Collection<Value> values) {
        return values.stream().allMatch(value -> value.equals(Value.NULL));
    }

    private boolean checkValue(Key key, Value column, Value expectedValue, byte[] actualValue) {
        if (expectedValue.equals(Value.get((byte[])actualValue)) || expectedValue instanceof Value.ByteSegmentValue && expectedValue.equals(Value.get((byte[])actualValue, (int)0, (int)(actualValue != null ? actualValue.length : 0)))) {
            return true;
        }
        logger.info("Unexpected value for key=[{}], column=[{}], expected=[{}], actual=[{}]", new Object[]{key, column, expectedValue, actualValue});
        return false;
    }

    static {
        BatchExpectedValueOperations.checkValuesPolicy.respondAllOps = true;
    }
}

