/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.operations.batch;

import com.aerospike.client.Value;
import com.playtika.janusgraph.aerospike.operations.batch.UpdateValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BatchUpdates {
    public static final String INDEX_STORE_NAME = "graphindex";
    public static final String EDGE_STORE_NAME = "edgestore";
    public static final String IDS_STORE_NAME = "janusgraph_ids";
    public static final Set<String> REGULAR_STORE_NAMES = new HashSet<String>(Arrays.asList("graphindex", "edgestore"));
    private final UpdatesOrdered updatesOrdered;
    private final Map<String, Map<Value, Map<Value, Value>>> updatesByStore;

    public BatchUpdates(Map<String, Map<Value, Map<Value, Value>>> updatesByStore) {
        this.updatesOrdered = BatchUpdates.orderUpdates(updatesByStore);
        this.updatesByStore = updatesByStore;
    }

    private static UpdatesOrdered orderUpdates(Map<String, Map<Value, Map<Value, Value>>> updatesByStore) {
        ArrayList<UpdateValue> indexDeletion = new ArrayList<UpdateValue>();
        ArrayList<UpdateValue> edgeDeletion = new ArrayList<UpdateValue>();
        ArrayList<UpdateValue> edgeCreation = new ArrayList<UpdateValue>();
        ArrayList<UpdateValue> indexCreation = new ArrayList<UpdateValue>();
        ArrayList<UpdateValue> other = new ArrayList<UpdateValue>();
        for (Map.Entry<String, Map<Value, Map<Value, Value>>> updatesByStoreEntry : updatesByStore.entrySet()) {
            String storeName = updatesByStoreEntry.getKey();
            block9: for (Map.Entry<Value, Map<Value, Value>> keyUpdate : updatesByStoreEntry.getValue().entrySet()) {
                Value key = keyUpdate.getKey();
                switch (storeName) {
                    case "graphindex": {
                        Split<Map<Value, Value>> split = BatchUpdates.splitToCreationAndDeletion(keyUpdate.getValue());
                        if (split.created != null) {
                            indexCreation.add(new UpdateValue(storeName, key, (Map)split.created));
                        }
                        if (split.deleted == null) continue block9;
                        indexDeletion.add(new UpdateValue(storeName, key, (Map)split.deleted));
                        continue block9;
                    }
                    case "edgestore": {
                        Split<Map<Value, Value>> split = BatchUpdates.splitToCreationAndDeletion(keyUpdate.getValue());
                        if (split.created != null) {
                            edgeCreation.add(new UpdateValue(storeName, key, (Map)split.created));
                        }
                        if (split.deleted == null) continue block9;
                        edgeDeletion.add(new UpdateValue(storeName, key, (Map)split.deleted));
                        continue block9;
                    }
                }
                other.add(new UpdateValue(storeName, key, keyUpdate.getValue()));
            }
        }
        return new UpdatesOrdered(indexDeletion, edgeDeletion, edgeCreation, indexCreation, other);
    }

    private static Split<Map<Value, Value>> splitToCreationAndDeletion(Map<Value, Value> updates) {
        boolean onlyCreation = true;
        boolean onlyDeletion = true;
        for (Map.Entry<Value, Value> updateEntry : updates.entrySet()) {
            if (updateEntry.getValue() == null) {
                onlyCreation = false;
                continue;
            }
            onlyDeletion = false;
        }
        if (onlyCreation) {
            return new Split<Object>(updates, null);
        }
        if (onlyDeletion) {
            return new Split<Map<Value, Value>>(null, updates);
        }
        HashMap creation = new HashMap(updates.size());
        HashMap<Value, Value> deletion = new HashMap<Value, Value>(updates.size());
        for (Map.Entry<Value, Value> updateEntry : updates.entrySet()) {
            if (updateEntry.getValue() == null) {
                deletion.put(updateEntry.getKey(), null);
                continue;
            }
            deletion.put(updateEntry.getKey(), updateEntry.getValue());
        }
        return new Split<Map<Value, Value>>(creation, deletion);
    }

    public UpdatesOrdered getUpdates() {
        return this.updatesOrdered;
    }

    public Map<String, Map<Value, Map<Value, Value>>> getUpdatesByStore() {
        return this.updatesByStore;
    }

    static class UpdatesOrdered {
        final List<UpdateValue> indexDeletion;
        final List<UpdateValue> edgeDeletion;
        final List<UpdateValue> edgeCreation;
        final List<UpdateValue> indexCreation;
        final List<UpdateValue> other;

        UpdatesOrdered(List<UpdateValue> indexDeletion, List<UpdateValue> edgeDeletion, List<UpdateValue> edgeCreation, List<UpdateValue> indexCreation, List<UpdateValue> other) {
            this.indexDeletion = indexDeletion;
            this.edgeDeletion = edgeDeletion;
            this.edgeCreation = edgeCreation;
            this.indexCreation = indexCreation;
            this.other = other;
        }
    }

    private static class Split<V> {
        final V created;
        final V deleted;

        public Split(V created, V deleted) {
            this.created = created;
            this.deleted = deleted;
        }
    }
}

