/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.operations.batch;

import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.playtika.janusgraph.aerospike.operations.AerospikeOperations;
import com.playtika.janusgraph.aerospike.operations.BasicMutateOperations;
import com.playtika.janusgraph.aerospike.operations.batch.BatchExpectedValueOperations;
import com.playtika.janusgraph.aerospike.operations.batch.BatchLocks;
import com.playtika.janusgraph.aerospike.operations.batch.BatchUpdateOperations;
import com.playtika.janusgraph.aerospike.operations.batch.BatchUpdateSerde;
import com.playtika.janusgraph.aerospike.operations.batch.BatchUpdates;
import com.playtika.janusgraph.aerospike.operations.batch.ExpectedValue;
import java.time.Clock;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import nosql.batch.update.BatchOperations;
import nosql.batch.update.UpdateOperations;
import nosql.batch.update.aerospike.lock.AerospikeExpectedValuesOperations;
import nosql.batch.update.aerospike.lock.AerospikeLock;
import nosql.batch.update.aerospike.lock.AerospikeLockOperations;
import nosql.batch.update.aerospike.wal.AerospikeBatchUpdateSerde;
import nosql.batch.update.aerospike.wal.AerospikeWriteAheadLogManager;

public class BatchOperationsUtil {
    public static BatchOperations<BatchLocks, BatchUpdates, AerospikeLock, Value> batchOperations(AerospikeOperations aerospikeOperations, String walNamespace, String walSetName, Clock clock, ExecutorService aerospikeExecutorService, ExecutorService batchExecutorService) {
        AerospikeWriteAheadLogManager<BatchLocks, BatchUpdates, Map<Key, ExpectedValue>> walManager = BatchOperationsUtil.walManager(aerospikeOperations, walNamespace, walSetName, clock, aerospikeExecutorService);
        AerospikeLockOperations<BatchLocks, Map<Key, ExpectedValue>> lockOperations = BatchOperationsUtil.lockOperations(aerospikeOperations, aerospikeExecutorService);
        BatchUpdateOperations updateOperations = BatchOperationsUtil.updateOperations(aerospikeOperations);
        return new BatchOperations(walManager, lockOperations, (UpdateOperations)updateOperations, batchExecutorService);
    }

    public static BatchUpdateOperations updateOperations(AerospikeOperations aerospikeOperations) {
        return new BatchUpdateOperations(new BasicMutateOperations(aerospikeOperations), aerospikeOperations.getAerospikeExecutor());
    }

    public static AerospikeLockOperations<BatchLocks, Map<Key, ExpectedValue>> lockOperations(AerospikeOperations aerospikeOperations, ExecutorService executorService) {
        return new AerospikeLockOperations(aerospikeOperations.getClient(), (AerospikeExpectedValuesOperations)new BatchExpectedValueOperations(aerospikeOperations), executorService);
    }

    public static AerospikeWriteAheadLogManager<BatchLocks, BatchUpdates, Map<Key, ExpectedValue>> walManager(AerospikeOperations aerospikeOperations, String walNamespace, String walSetName, Clock clock, ExecutorService executorService) {
        return new AerospikeWriteAheadLogManager(aerospikeOperations.getClient(), walNamespace, walSetName, (AerospikeBatchUpdateSerde)new BatchUpdateSerde(aerospikeOperations), clock);
    }
}

