/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.operations.batch;

import com.playtika.janusgraph.aerospike.operations.BasicMutateOperations;
import com.playtika.janusgraph.aerospike.operations.batch.BatchUpdates;
import com.playtika.janusgraph.aerospike.util.AsyncUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import nosql.batch.update.UpdateOperations;

public class BatchUpdateOperations
implements UpdateOperations<BatchUpdates> {
    private final BasicMutateOperations mutateOperations;
    private final ExecutorService executorService;

    public BatchUpdateOperations(BasicMutateOperations mutateOperations, ExecutorService executorService) {
        this.mutateOperations = mutateOperations;
        this.executorService = executorService;
    }

    public void updateMany(BatchUpdates batchUpdates, boolean calledByWal) {
        BatchUpdates.UpdatesOrdered updatesOrdered = batchUpdates.getUpdates();
        AsyncUtil.completeAll(BatchUpdateOperations.concat(updatesOrdered.indexDeletion, updatesOrdered.edgeCreation), updateValue -> true, updateValue -> {
            this.mutateOperations.mutate(updateValue.storeName, updateValue.key, updateValue.values);
            return true;
        }, () -> null, this.executorService);
        AsyncUtil.completeAll(BatchUpdateOperations.concat(updatesOrdered.indexCreation, updatesOrdered.edgeDeletion), updateValue -> true, updateValue -> {
            this.mutateOperations.mutate(updateValue.storeName, updateValue.key, updateValue.values);
            return true;
        }, () -> null, this.executorService);
        AsyncUtil.completeAll(updatesOrdered.other, updateValue -> true, updateValue -> {
            this.mutateOperations.mutate(updateValue.storeName, updateValue.key, updateValue.values);
            return true;
        }, () -> null, this.executorService);
    }

    private static <V> List<V> concat(List<V> list1, List<V> list2) {
        if (list1.isEmpty()) {
            return list2;
        }
        if (list2.isEmpty()) {
            return list1;
        }
        ArrayList<V> result = new ArrayList<V>(list1.size() + list2.size());
        result.addAll(list1);
        result.addAll(list2);
        return result;
    }
}

