/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.janusgraph.aerospike.operations.batch;

import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.playtika.janusgraph.aerospike.operations.AerospikeOperations;
import com.playtika.janusgraph.aerospike.operations.batch.BatchLocks;
import com.playtika.janusgraph.aerospike.operations.batch.BatchUpdate;
import com.playtika.janusgraph.aerospike.operations.batch.BatchUpdates;
import com.playtika.janusgraph.aerospike.operations.batch.ExpectedValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nosql.batch.update.aerospike.wal.AerospikeBatchUpdateSerde;

public class BatchUpdateSerde
implements AerospikeBatchUpdateSerde<BatchLocks, BatchUpdates, Map<Key, ExpectedValue>> {
    private static final String LOCKS_BIN = "locks";
    private static final String MUTATIONS_BIN = "mutations";
    private final AerospikeOperations aerospikeOperations;

    public BatchUpdateSerde(AerospikeOperations aerospikeOperations) {
        this.aerospikeOperations = aerospikeOperations;
    }

    public List<Bin> write(nosql.batch.update.BatchUpdate<BatchLocks, BatchUpdates> batch) {
        return Arrays.asList(new Bin(LOCKS_BIN, BatchUpdateSerde.stringMapToValue(((BatchLocks)batch.locks()).getLocksByStore())), new Bin(MUTATIONS_BIN, BatchUpdateSerde.stringMapToValue(((BatchUpdates)batch.updates()).getUpdatesByStore())));
    }

    public nosql.batch.update.BatchUpdate<BatchLocks, BatchUpdates> read(Map<String, Object> bins) {
        return new BatchUpdate(new BatchLocks(BatchUpdateSerde.wrapMap((Map)bins.get(LOCKS_BIN)), this.aerospikeOperations), new BatchUpdates(BatchUpdateSerde.wrapMap((Map)bins.get(MUTATIONS_BIN))));
    }

    private static Value stringMapToValue(Map<String, Map<Value, Map<Value, Value>>> map) {
        HashMap<Value, Map<Value, Map<Value, Value>>> locksValue = new HashMap<Value, Map<Value, Map<Value, Value>>>(map.size());
        for (Map.Entry<String, Map<Value, Map<Value, Value>>> locksEntry : map.entrySet()) {
            locksValue.put(Value.get((String)locksEntry.getKey()), locksEntry.getValue());
        }
        return Value.get(locksValue);
    }

    private static Map<String, Map<Value, Map<Value, Value>>> wrapMap(Map<String, Map<byte[], Map<byte[], byte[]>>> map) {
        HashMap<String, Map<Value, Map<Value, Value>>> resultMap = new HashMap<String, Map<Value, Map<Value, Value>>>(map.size());
        for (Map.Entry<String, Map<byte[], Map<byte[], byte[]>>> mapEntry : map.entrySet()) {
            resultMap.put(mapEntry.getKey(), BatchUpdateSerde.wrapBytesBytesMap(mapEntry.getValue()));
        }
        return resultMap;
    }

    private static Map<Value, Map<Value, Value>> wrapBytesBytesMap(Map<byte[], Map<byte[], byte[]>> map) {
        HashMap<Value, Map<Value, Value>> resultMap = new HashMap<Value, Map<Value, Value>>(map.size());
        for (Map.Entry<byte[], Map<byte[], byte[]>> mapEntry : map.entrySet()) {
            resultMap.put(Value.get((byte[])mapEntry.getKey()), BatchUpdateSerde.wrapBytesMap(mapEntry.getValue()));
        }
        return resultMap;
    }

    private static Map<Value, Value> wrapBytesMap(Map<byte[], byte[]> map) {
        HashMap<Value, Value> resultMap = new HashMap<Value, Value>(map.size());
        for (Map.Entry<byte[], byte[]> mapEntry : map.entrySet()) {
            resultMap.put(Value.get((byte[])mapEntry.getKey()), Value.get((byte[])mapEntry.getValue()));
        }
        return resultMap;
    }
}

