/*
 * Decompiled with CFR 0.152.
 */
package nosql.batch.update.aerospike.basic;

import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import nosql.batch.update.BatchUpdate;
import nosql.batch.update.aerospike.basic.AerospikeBasicBatchUpdate;
import nosql.batch.update.aerospike.basic.Record;
import nosql.batch.update.aerospike.basic.lock.AerospikeBasicBatchLocks;
import nosql.batch.update.aerospike.wal.AerospikeBatchUpdateSerde;

public class AerospikeBasicBatchUpdateSerde
implements AerospikeBatchUpdateSerde<AerospikeBasicBatchLocks, List<Record>, List<Record>> {
    private static final String EXPECTED_VALUES_BIN_NAME = "expected_values";
    private static final String UPDATES_BIN_NAME = "updates";

    @Override
    public List<Bin> write(BatchUpdate<AerospikeBasicBatchLocks, List<Record>> batch) {
        return Arrays.asList(new Bin(EXPECTED_VALUES_BIN_NAME, AerospikeBasicBatchUpdateSerde.recordsToValue((List<Record>)((AerospikeBasicBatchLocks)batch.locks()).expectedValues())), new Bin(UPDATES_BIN_NAME, AerospikeBasicBatchUpdateSerde.recordsToValue((List)batch.updates())));
    }

    @Override
    public BatchUpdate<AerospikeBasicBatchLocks, List<Record>> read(Map<String, Object> bins) {
        return new AerospikeBasicBatchUpdate(new AerospikeBasicBatchLocks(AerospikeBasicBatchUpdateSerde.recordsFromValue(bins.get(EXPECTED_VALUES_BIN_NAME))), AerospikeBasicBatchUpdateSerde.recordsFromValue(bins.get(UPDATES_BIN_NAME)));
    }

    private static Value recordsToValue(List<Record> records) {
        return Value.get(records.stream().map(AerospikeBasicBatchUpdateSerde::recordToValue).collect(Collectors.toList()));
    }

    private static Value recordToValue(Record record) {
        ArrayList<Value> recordValues = new ArrayList<Value>();
        recordValues.add(Value.get((String)record.key.namespace));
        recordValues.add(Value.get((String)record.key.setName));
        recordValues.add(record.key.userKey);
        for (Bin bin : record.bins) {
            recordValues.add(Value.get((String)bin.name));
            recordValues.add(bin.value);
        }
        return Value.get(recordValues);
    }

    private static List<Record> recordsFromValue(Object value) {
        List listOfRecords = (List)value;
        ArrayList<Record> records = new ArrayList<Record>(listOfRecords.size());
        for (Object record : listOfRecords) {
            records.add(AerospikeBasicBatchUpdateSerde.recordFromValues((List)record));
        }
        return records;
    }

    private static Record recordFromValues(List<Object> recordValue) {
        Iterator<Object> it = recordValue.iterator();
        Key key = new Key((String)it.next(), (String)it.next(), Value.get((Object)it.next()));
        ArrayList<Bin> bins = new ArrayList<Bin>((recordValue.size() - 3) / 2);
        while (it.hasNext()) {
            bins.add(new Bin((String)it.next(), Value.get((Object)it.next())));
        }
        return new Record(key, bins);
    }
}

