/*
 * Decompiled with CFR 0.152.
 */
package nosql.batch.update.aerospike.basic;

import com.aerospike.client.BatchRead;
import com.aerospike.client.Bin;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Value;
import java.util.ArrayList;
import java.util.List;
import nosql.batch.update.aerospike.basic.Record;
import nosql.batch.update.aerospike.lock.AerospikeExpectedValuesOperations;
import nosql.batch.update.aerospike.lock.AerospikeLock;
import nosql.batch.update.lock.Lock;
import nosql.batch.update.lock.PermanentLockingException;

public class AerospikeBasicExpectedValueOperations
implements AerospikeExpectedValuesOperations<List<Record>> {
    private final IAerospikeClient client;

    public AerospikeBasicExpectedValueOperations(IAerospikeClient client) {
        this.client = client;
    }

    @Override
    public void checkExpectedValues(List<AerospikeLock> locks, List<Record> expectedValues) throws PermanentLockingException {
        int i;
        if (locks.size() != expectedValues.size()) {
            throw new IllegalArgumentException("locks.size() != expectedValues.size()");
        }
        ArrayList<BatchRead> batchReads = new ArrayList<BatchRead>(expectedValues.size());
        ArrayList<Record> expectedValuesToCheck = new ArrayList<Record>(expectedValues.size());
        int n = expectedValues.size();
        for (i = 0; i < n; ++i) {
            if (locks.get((int)i).lockType == Lock.LockType.SAME_BATCH) continue;
            Record record = expectedValues.get(i);
            batchReads.add(new BatchRead(record.key, (String[])record.bins.stream().map(bin -> bin.name).toArray(String[]::new)));
            expectedValuesToCheck.add(record);
        }
        this.client.get(null, batchReads);
        n = expectedValuesToCheck.size();
        for (i = 0; i < n; ++i) {
            this.checkValues((BatchRead)batchReads.get(i), (Record)expectedValuesToCheck.get(i));
        }
    }

    private void checkValues(BatchRead batchRead, Record expectedValues) throws PermanentLockingException {
        for (Bin bin : expectedValues.bins) {
            Object actualValue = batchRead.record != null ? batchRead.record.getValue(bin.name) : null;
            if (this.equals(actualValue, bin.value)) continue;
            throw new PermanentLockingException(String.format("Unexpected value: bin=[%s], expected=[%s], actual=[%s]", bin.name, bin.value, actualValue));
        }
    }

    private boolean equals(Object actualValue, Value expectedValue) {
        return expectedValue.equals(Value.get((Object)actualValue));
    }
}

