/*
 * Decompiled with CFR 0.152.
 */
package nosql.batch.update.aerospike.basic;

import com.aerospike.client.Bin;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.policy.WritePolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import nosql.batch.update.UpdateOperations;
import nosql.batch.update.aerospike.basic.Record;

public class AerospikeBasicUpdateOperations
implements UpdateOperations<List<Record>> {
    private final IAerospikeClient client;
    private final WritePolicy writePolicy;
    private final ExecutorService executorService;

    public AerospikeBasicUpdateOperations(IAerospikeClient client, ExecutorService executorService) {
        this.client = client;
        this.writePolicy = client.getWritePolicyDefault();
        this.executorService = executorService;
    }

    public void updateMany(List<Record> batchOfUpdates, boolean calledByWal) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(batchOfUpdates.size());
        for (Record record : batchOfUpdates) {
            futures.add(CompletableFuture.runAsync(() -> this.update(record), this.executorService));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
    }

    private void update(Record record) {
        this.client.put(this.writePolicy, record.key, record.bins.toArray(new Bin[0]));
    }
}

