/*
 * Decompiled with CFR 0.152.
 */
package nosql.batch.update.aerospike.lock;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import nosql.batch.update.aerospike.lock.AerospikeBatchLocks;
import nosql.batch.update.aerospike.lock.AerospikeExpectedValuesOperations;
import nosql.batch.update.aerospike.lock.AerospikeLock;
import nosql.batch.update.lock.Lock;
import nosql.batch.update.lock.LockOperations;
import nosql.batch.update.lock.LockingException;
import nosql.batch.update.lock.PermanentLockingException;
import nosql.batch.update.lock.TemporaryLockingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AerospikeLockOperations<LOCKS extends AerospikeBatchLocks<EV>, EV>
implements LockOperations<LOCKS, AerospikeLock, Value> {
    private static final Logger logger = LoggerFactory.getLogger(AerospikeLockOperations.class);
    private static final String BATCH_ID_BIN_NAME = "batch_id";
    private static final WritePolicy checkValuesPolicy = new WritePolicy();
    private final IAerospikeClient aerospikeClient;
    private final WritePolicy putLockPolicy;
    private final WritePolicy deleteLockPolicy;
    private final AerospikeExpectedValuesOperations<EV> expectedValuesOperations;
    private final ExecutorService aerospikeExecutor;

    public AerospikeLockOperations(IAerospikeClient aerospikeClient, AerospikeExpectedValuesOperations<EV> expectedValuesOperations, ExecutorService aerospikeExecutor) {
        this.putLockPolicy = this.configurePutLockPolicy(aerospikeClient.getWritePolicyDefault());
        this.aerospikeClient = aerospikeClient;
        this.aerospikeExecutor = aerospikeExecutor;
        this.deleteLockPolicy = this.putLockPolicy;
        this.expectedValuesOperations = expectedValuesOperations;
    }

    private WritePolicy configurePutLockPolicy(WritePolicy writePolicyDefault) {
        WritePolicy writePolicy = new WritePolicy(writePolicyDefault);
        writePolicy.recordExistsAction = RecordExistsAction.CREATE_ONLY;
        writePolicy.expiration = -1;
        return writePolicy;
    }

    public List<AerospikeLock> acquire(Value batchId, LOCKS batchLocks, boolean checkBatchId) throws LockingException {
        List<AerospikeLock> keysLocked = this.putLocks(batchId, batchLocks, checkBatchId);
        this.checkExpectedValues(batchLocks, keysLocked);
        return keysLocked;
    }

    protected List<AerospikeLock> putLocks(Value batchId, LOCKS batchLocks, boolean checkTransactionId) throws TemporaryLockingException {
        List<Key> keys = batchLocks.keysToLock();
        if (keys.size() == 1) {
            return Collections.singletonList(this.putLock(batchId, keys.get(0), checkTransactionId));
        }
        ArrayList<CompletableFuture<LockResult<AerospikeLock>>> futures = new ArrayList<CompletableFuture<LockResult<AerospikeLock>>>(keys.size());
        AtomicReference fail = new AtomicReference();
        for (Key lockKey : keys) {
            futures.add(CompletableFuture.supplyAsync(() -> {
                try {
                    if (fail.get() != null) {
                        return null;
                    }
                    AerospikeLock lock = this.putLock(batchId, lockKey, checkTransactionId);
                    return new LockResult<AerospikeLock>(lock);
                }
                catch (Throwable t) {
                    fail.set(t);
                    return new LockResult(t);
                }
            }, this.aerospikeExecutor));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        return AerospikeLockOperations.processResults(futures);
    }

    static List<AerospikeLock> processResults(List<CompletableFuture<LockResult<AerospikeLock>>> lockResults) throws LockingException {
        ArrayList<AerospikeLock> locks = new ArrayList<AerospikeLock>(lockResults.size());
        Throwable resultError = null;
        for (CompletableFuture<LockResult<AerospikeLock>> future : lockResults) {
            LockResult<AerospikeLock> lockResult = future.join();
            if (lockResult == null) continue;
            if (lockResult.throwable != null) {
                if (lockResult.throwable instanceof LockingException) {
                    if (resultError == null) {
                        resultError = lockResult.throwable;
                    }
                } else {
                    resultError = lockResult.throwable;
                    break;
                }
            }
            locks.add((AerospikeLock)((Object)lockResult.value));
        }
        if (resultError != null) {
            logger.error("Error while putting locks", resultError);
            throw resultError instanceof LockingException ? (LockingException)resultError : new RuntimeException(resultError);
        }
        return locks;
    }

    private AerospikeLock putLock(Value batchId, Key lockKey, boolean checkBatchId) throws TemporaryLockingException {
        try {
            this.aerospikeClient.add(this.putLockPolicy, lockKey, new Bin[]{new Bin(BATCH_ID_BIN_NAME, batchId)});
            logger.trace("acquired lock key=[{}], batchId=[{}]", (Object)lockKey, (Object)batchId);
            return new AerospikeLock(Lock.LockType.LOCKED, lockKey);
        }
        catch (AerospikeException ae) {
            if (ae.getResultCode() == 5) {
                if (checkBatchId) {
                    Value actualBatchId = this.getBatchIdOfLock(lockKey);
                    if (batchId.equals(actualBatchId)) {
                        logger.info("Previously locked by this batch update key=[{}], batchId=[{}]", (Object)lockKey, (Object)batchId);
                        return new AerospikeLock(Lock.LockType.SAME_BATCH, lockKey);
                    }
                    logger.error("Locked by other batch update key=[{}], batchId=[{}], actualBatchId=[{}]", new Object[]{lockKey, batchId, actualBatchId});
                    throw new TemporaryLockingException(String.format("Locked by other batch update key=[%s], batchId=[%s], actualBatchId=[%s]", lockKey, batchId, actualBatchId));
                }
                Value batchIdLocked = this.getBatchIdOfLock(lockKey);
                logger.info("Locked by concurrent update key=[{}], batchId=[{}], batchIdLocked=[{}]", new Object[]{lockKey, batchId, batchIdLocked});
                throw new TemporaryLockingException(String.format("Locked by concurrent update key=[%s], batchId=[%s], batchIdLocked=[%s]", lockKey, batchId, batchIdLocked));
            }
            logger.error("Unexpected error while acquiring lock key=[{}], batchId=[{}]", (Object)lockKey, (Object)batchId);
            throw ae;
        }
    }

    protected void checkExpectedValues(LOCKS batchLocks, List<AerospikeLock> keysLocked) throws PermanentLockingException {
        this.expectedValuesOperations.checkExpectedValues(keysLocked, batchLocks.expectedValues());
    }

    private Value getBatchIdOfLock(Key lockKey) {
        Record record = this.aerospikeClient.get(null, lockKey);
        return this.getBatchId(record);
    }

    private Value getBatchId(Record record) {
        return record != null ? Value.get((Object)record.getValue(BATCH_ID_BIN_NAME)) : Value.getAsNull();
    }

    public List<AerospikeLock> getLockedByBatchUpdate(LOCKS aerospikeBatchLocks, Value batchId) {
        List<Key> keys = aerospikeBatchLocks.keysToLock();
        Key[] keysArray = keys.toArray(new Key[0]);
        Record[] records = this.aerospikeClient.get(null, keysArray);
        ArrayList<AerospikeLock> keysFiltered = new ArrayList<AerospikeLock>(keys.size());
        int m = keysArray.length;
        for (int i = 0; i < m; ++i) {
            Record record = records[i];
            if (record == null || !batchId.equals(this.getBatchId(record))) continue;
            keysFiltered.add(new AerospikeLock(Lock.LockType.SAME_BATCH, keysArray[i]));
        }
        return keysFiltered;
    }

    public void release(List<AerospikeLock> locks, Value batchId) {
        if (locks.size() == 1) {
            this.releaseLock(locks.get(0), batchId);
            return;
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(locks.size());
        for (AerospikeLock lock : locks) {
            futures.add(CompletableFuture.runAsync(() -> this.releaseLock(lock, batchId), this.aerospikeExecutor));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
    }

    protected void releaseLock(AerospikeLock lock, Value batchId) {
        this.aerospikeClient.delete(this.deleteLockPolicy, lock.key);
        logger.trace("released lock key=[{}], batchId=[{}]", (Object)lock.key, (Object)batchId);
    }

    static {
        AerospikeLockOperations.checkValuesPolicy.respondAllOps = true;
    }

    public static class LockResult<V> {
        public final V value;
        public final Throwable throwable;

        public LockResult(V value) {
            this.value = value;
            this.throwable = null;
        }

        public LockResult(Throwable throwable) {
            this.value = null;
            this.throwable = throwable;
        }
    }
}

