/*
 * Decompiled with CFR 0.152.
 */
package nosql.batch.update;

import nosql.batch.update.BatchOperations;
import nosql.batch.update.BatchUpdate;
import nosql.batch.update.lock.Lock;
import nosql.batch.update.wal.WriteAheadLogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchUpdater<LOCKS, UPDATES, L extends Lock, BATCH_ID> {
    private static final Logger logger = LoggerFactory.getLogger(BatchUpdater.class);
    private final WriteAheadLogManager<LOCKS, UPDATES, BATCH_ID> writeAheadLogManager;
    private BatchOperations<LOCKS, UPDATES, L, BATCH_ID> batchOperations;

    public BatchUpdater(BatchOperations<LOCKS, UPDATES, L, BATCH_ID> batchOperations) {
        this.batchOperations = batchOperations;
        this.writeAheadLogManager = batchOperations.getWriteAheadLogManager();
    }

    public void update(BatchUpdate<LOCKS, UPDATES> batchUpdate) {
        BATCH_ID batchId = this.writeAheadLogManager.writeBatch(batchUpdate);
        logger.trace("Added batch to WAL: {}", batchId);
        this.batchOperations.processAndDeleteTransaction(batchId, batchUpdate, false);
    }
}

