/*
 * Decompiled with CFR 0.152.
 */
package nosql.batch.update.util;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class AsyncUtil {
    private static final long WAIT_TIMEOUT_IN_NANOS = Duration.ofSeconds(10L).toNanos();

    public static <V> List<V> supplyAsyncAll(List<Supplier<V>> suppliers, ExecutorService executorService) {
        List<CompletableFuture> futures = suppliers.stream().map(supplier -> CompletableFuture.supplyAsync(supplier, executorService)).collect(Collectors.toList());
        return (List)((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(aVoid -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()))).join();
    }

    public static boolean shutdownAndAwaitTermination(ExecutorService service) {
        service.shutdown();
        try {
            long halfTimeoutNanos = WAIT_TIMEOUT_IN_NANOS / 2L;
            if (!service.awaitTermination(halfTimeoutNanos, TimeUnit.NANOSECONDS)) {
                service.shutdownNow();
                service.awaitTermination(halfTimeoutNanos, TimeUnit.NANOSECONDS);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            service.shutdownNow();
        }
        return service.isTerminated();
    }
}

