/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.cloud2.methodhandler;

import feign.MethodMetadata;
import feign.Target;
import feign.Util;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.springframework.lang.Nullable;
import reactivefeign.cloud2.ReactiveFeignCircuitBreakerFactory;
import reactivefeign.cloud2.methodhandler.CircuitBreakerMethodHandler;
import reactivefeign.methodhandler.MethodHandler;
import reactivefeign.methodhandler.MethodHandlerFactory;

public class CircuitBreakerMethodHandlerFactory
implements MethodHandlerFactory {
    private final MethodHandlerFactory methodHandlerFactory;
    private final ReactiveFeignCircuitBreakerFactory reactiveFeignCircuitBreakerFactory;
    private final Function<Throwable, Object> fallbackFactory;
    private Target target;

    public CircuitBreakerMethodHandlerFactory(MethodHandlerFactory methodHandlerFactory, ReactiveFeignCircuitBreakerFactory reactiveFeignCircuitBreakerFactory, @Nullable Function<Throwable, Object> fallbackFactory) {
        this.methodHandlerFactory = (MethodHandlerFactory)Util.checkNotNull((Object)methodHandlerFactory, (String)"methodHandlerFactory must not be null", (Object[])new Object[0]);
        this.reactiveFeignCircuitBreakerFactory = (ReactiveFeignCircuitBreakerFactory)Util.checkNotNull((Object)reactiveFeignCircuitBreakerFactory, (String)"reactiveFeignCircuitBreakerFactory must not be null", (Object[])new Object[0]);
        this.fallbackFactory = fallbackFactory;
    }

    public void target(Target target) {
        this.target = target;
        this.methodHandlerFactory.target(target);
    }

    public MethodHandler create(MethodMetadata metadata) {
        return new CircuitBreakerMethodHandler(this.target, metadata, this.methodHandlerFactory.create(metadata), this.reactiveFeignCircuitBreakerFactory, this.fallbackFactory);
    }

    public MethodHandler createDefault(Method method) {
        return this.methodHandlerFactory.createDefault(method);
    }
}

