/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.wiremock;

import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.jetty9.JettyHttpServer;
import wiremock.org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import wiremock.org.eclipse.jetty.io.NetworkTrafficListener;
import wiremock.org.eclipse.jetty.server.ConnectionFactory;
import wiremock.org.eclipse.jetty.server.HttpConfiguration;
import wiremock.org.eclipse.jetty.server.HttpConnectionFactory;
import wiremock.org.eclipse.jetty.server.ServerConnector;

public class WireMockServerConfigurations {
    public static WireMockConfiguration h2cConfig() {
        return WireMockServerConfigurations.h2cConfig(false, 100);
    }

    public static WireMockConfiguration h2cConfig(final boolean includeH1, final int maxConcurrentCalls) {
        return WireMockConfiguration.wireMockConfig().dynamicPort().asynchronousResponseEnabled(true).httpServerFactory((options, adminRequestHandler, stubRequestHandler) -> new JettyHttpServer(options, adminRequestHandler, stubRequestHandler){

            protected ServerConnector createHttpConnector(String bindAddress, int port, JettySettings jettySettings, NetworkTrafficListener listener) {
                ConnectionFactory[] connectionFactoryArray;
                HttpConfiguration httpConfig = this.createHttpConfig(jettySettings);
                HTTP2CServerConnectionFactory http2CFactory = new HTTP2CServerConnectionFactory(httpConfig);
                http2CFactory.setMaxConcurrentStreams(maxConcurrentCalls);
                if (includeH1) {
                    ConnectionFactory[] connectionFactoryArray2 = new ConnectionFactory[2];
                    connectionFactoryArray2[0] = new HttpConnectionFactory(httpConfig);
                    connectionFactoryArray = connectionFactoryArray2;
                    connectionFactoryArray2[1] = http2CFactory;
                } else {
                    ConnectionFactory[] connectionFactoryArray3 = new ConnectionFactory[1];
                    connectionFactoryArray = connectionFactoryArray3;
                    connectionFactoryArray3[0] = http2CFactory;
                }
                return this.createServerConnector(bindAddress, jettySettings, port, listener, connectionFactoryArray);
            }
        });
    }
}

