/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.spring.config;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import feign.Contract;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.cloud.CloudReactiveFeign;
import reactivefeign.spring.config.ReactiveFeignHystrixConfigurator;
import reactivefeign.spring.config.ReactiveFeignRibbonConfigurator;
import reactivefeign.webclient.WebReactiveFeign;

@Configuration
public class ReactiveFeignClientsConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Contract reactiveFeignContract() {
        return new SpringMvcContract();
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnClass(value={WebReactiveFeign.class})
    @ConditionalOnMissingBean(ignoredType={"reactivefeign.cloud.CloudReactiveFeign.Builder"})
    public ReactiveFeignBuilder reactiveFeignBuilder() {
        return WebReactiveFeign.builder();
    }

    @AutoConfigureAfter(value={ReactiveFeignClientsConfiguration.class})
    @Configuration
    @ConditionalOnClass(value={HystrixCommand.class, LoadBalancerCommand.class, CloudReactiveFeign.class})
    @ConditionalOnProperty(name={"reactive.feign.cloud.enabled"}, matchIfMissing=true)
    protected static class ReactiveFeignClientsCloudConfiguration {
        protected ReactiveFeignClientsCloudConfiguration() {
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnProperty(name={"reactive.feign.hystrix.enabled"}, matchIfMissing=true)
        public ReactiveFeignHystrixConfigurator reactiveFeignHystrixConfigurator() {
            return new ReactiveFeignHystrixConfigurator();
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnProperty(name={"reactive.feign.ribbon.enabled"}, matchIfMissing=true)
        public ReactiveFeignRibbonConfigurator reactiveFeignRibbonConfigurator() {
            return new ReactiveFeignRibbonConfigurator();
        }

        @Bean
        @Primary
        @Scope(value="prototype")
        @ConditionalOnMissingBean
        public CloudReactiveFeign.Builder reactiveFeignCloudBuilder(ReactiveFeignBuilder reactiveFeignBuilder, @Value(value="${reactive.feign.hystrix.enabled:true}") boolean enableHystrix, @Value(value="${reactive.feign.ribbon.enabled:true}") boolean enableLoadBalancer) {
            CloudReactiveFeign.Builder cloudBuilder = CloudReactiveFeign.builder((ReactiveFeignBuilder)reactiveFeignBuilder);
            if (enableLoadBalancer) {
                cloudBuilder = cloudBuilder.enableLoadBalancer();
            }
            if (!enableHystrix) {
                cloudBuilder = cloudBuilder.disableHystrix();
            }
            return cloudBuilder;
        }
    }
}

