/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.spring.config;

import com.netflix.client.ClientFactory;
import com.netflix.client.DefaultLoadBalancerRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.cloud.CloudReactiveFeign;
import reactivefeign.cloud.LoadBalancerCommandFactory;
import reactivefeign.spring.config.ReactiveFeignClientFactoryBean;
import reactivefeign.spring.config.ReactiveFeignConfigurator;
import reactivefeign.spring.config.ReactiveFeignContext;

public class ReactiveFeignRibbonConfigurator
implements ReactiveFeignConfigurator {
    @Override
    public ReactiveFeignBuilder configure(ReactiveFeignBuilder reactiveFeignBuilder, ReactiveFeignClientFactoryBean factory, ReactiveFeignContext context) {
        if (!(reactiveFeignBuilder instanceof CloudReactiveFeign.Builder)) {
            throw new IllegalArgumentException("CloudReactiveFeign.Builder expected");
        }
        CloudReactiveFeign.Builder cloudBuilder = (CloudReactiveFeign.Builder)reactiveFeignBuilder;
        String clientName = factory.getName();
        LoadBalancerCommandFactory balancerCommandFactory = (LoadBalancerCommandFactory)context.getInstance(clientName, LoadBalancerCommandFactory.class);
        if (balancerCommandFactory == null) {
            DefaultClientConfigImpl clientConfig = DefaultClientConfigImpl.getClientConfigWithDefaultValues((String)clientName);
            RetryHandler retryHandler = this.getOrInstantiateRetryHandler(context, clientName, (IClientConfig)clientConfig);
            balancerCommandFactory = arg_0 -> ReactiveFeignRibbonConfigurator.lambda$configure$0(retryHandler, (IClientConfig)clientConfig, arg_0);
        }
        cloudBuilder = cloudBuilder.setLoadBalancerCommandFactory(balancerCommandFactory);
        return cloudBuilder;
    }

    private RetryHandler getOrInstantiateRetryHandler(ReactiveFeignContext context, String clientName, IClientConfig clientConfig) {
        RetryHandler retryHandler = (RetryHandler)context.getInstance(clientName, RetryHandler.class);
        if (retryHandler == null) {
            retryHandler = new DefaultLoadBalancerRetryHandler(clientConfig);
        }
        return retryHandler;
    }

    private static /* synthetic */ LoadBalancerCommand lambda$configure$0(RetryHandler retryHandler, IClientConfig clientConfig, String serviceName) {
        return LoadBalancerCommand.builder().withLoadBalancer(ClientFactory.getNamedLoadBalancer((String)serviceName)).withRetryHandler(retryHandler).withClientConfig(clientConfig).build();
    }
}

