/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainers.aerospike.enterprise;

import com.playtika.test.aerospike.AerospikeProperties;
import com.playtika.testcontainers.aerospike.enterprise.AerospikeEnterpriseProperties;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;

public class AerospikeEnterpriseConfigurer {
    private static final Logger log = LoggerFactory.getLogger(AerospikeEnterpriseConfigurer.class);
    private final AerospikeProperties aerospikeProperties;
    private final AerospikeEnterpriseProperties enterpriseProperties;

    public void configure(GenericContainer<?> aerospikeContainer) throws IOException, InterruptedException {
        if (this.aerospikeProperties.getFeatureKey() == null || this.aerospikeProperties.getFeatureKey().isEmpty()) {
            log.warn("Evaluation feature key file not provided by 'embedded.aerospike.featureKey' property. Pay attention to license details: https://github.com/aerospike/aerospike-server.docker/blob/master/enterprise/ENTERPRISE_LICENSE");
        }
        this.setupDisallowExpunge(aerospikeContainer);
    }

    private void setupDisallowExpunge(GenericContainer<?> aerospikeContainer) throws IOException, InterruptedException {
        if (!this.enterpriseProperties.isDurableDeletes()) {
            return;
        }
        log.info("Setting up 'disallow-expunge' to true...");
        String namespace = this.aerospikeProperties.getNamespace();
        Container.ExecResult result = aerospikeContainer.execInContainer(new String[]{"asadm", "-e", String.format("enable; manage config namespace %s param disallow-expunge to true", namespace)});
        if (result.getStderr().length() > 0) {
            throw new IllegalStateException("Failed to set up 'disallow-expunge' to true: " + result.getStderr());
        }
        log.info("Set up 'disallow-expunge' to true: {}", (Object)result.getStdout());
    }

    public AerospikeEnterpriseConfigurer(AerospikeProperties aerospikeProperties, AerospikeEnterpriseProperties enterpriseProperties) {
        this.aerospikeProperties = aerospikeProperties;
        this.enterpriseProperties = enterpriseProperties;
    }
}

