/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainers.aerospike.enterprise;

import java.util.Comparator;
import lombok.NonNull;

public final class ImageVersion
implements Comparable<ImageVersion> {
    private final int major;
    private final int minor;

    static ImageVersion parse(String version) {
        String[] parts = version.split("\\.");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid version: " + version);
        }
        try {
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            return new ImageVersion(major, minor);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version: " + version, e);
        }
    }

    @Override
    public int compareTo(@NonNull ImageVersion o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return Comparator.comparingInt(ImageVersion::getMajor).thenComparingInt(ImageVersion::getMinor).compare(this, o);
    }

    public ImageVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageVersion)) {
            return false;
        }
        ImageVersion other = (ImageVersion)o;
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        return this.getMinor() == other.getMinor();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMajor();
        result = result * 59 + this.getMinor();
        return result;
    }

    public String toString() {
        return "ImageVersion(major=" + this.getMajor() + ", minor=" + this.getMinor() + ")";
    }
}

