/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainers.aerospike.enterprise;

import com.playtika.testcontainer.aerospike.AerospikeProperties;
import com.playtika.testcontainers.aerospike.enterprise.AerospikeEnterpriseProperties;
import com.playtika.testcontainers.aerospike.enterprise.AsadmCommandExecutor;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public class AerospikeEnterpriseConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AerospikeEnterpriseConfigurer.class);
    private final AerospikeProperties aerospikeProperties;
    private final AerospikeEnterpriseProperties enterpriseProperties;

    public void configure(GenericContainer<?> aerospikeContainer) throws IOException, InterruptedException {
        if (this.aerospikeProperties.getFeatureKey() == null || this.aerospikeProperties.getFeatureKey().isBlank()) {
            log.warn("Evaluation feature key file not provided by 'embedded.aerospike.featureKey' property. Pay attention to license details: https://github.com/aerospike/aerospike-server.docker/blob/master/enterprise/ENTERPRISE_LICENSE");
        }
        String namespace = this.aerospikeProperties.getNamespace();
        AsadmCommandExecutor asadmCommandExecutor = new AsadmCommandExecutor(aerospikeContainer);
        log.info("Switching off 'stop-writes-sys-memory-pct'... ");
        asadmCommandExecutor.execute(String.format("manage config namespace %s param stop-writes-sys-memory-pct to 100", namespace));
        log.info("Success switching off 'stop-writes-sys-memory-pct'");
        if (this.enterpriseProperties.isDurableDeletes()) {
            log.info("Setting up 'disallow-expunge' to true...");
            asadmCommandExecutor.execute(String.format("manage config namespace %s param disallow-expunge to true", namespace));
            log.info("Success setting up 'disallow-expunge' to true");
        }
    }

    @Generated
    public AerospikeEnterpriseConfigurer(AerospikeProperties aerospikeProperties, AerospikeEnterpriseProperties enterpriseProperties) {
        this.aerospikeProperties = aerospikeProperties;
        this.enterpriseProperties = enterpriseProperties;
    }
}

