/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainers.aerospike.enterprise;

import java.util.Comparator;
import lombok.NonNull;

record ImageVersion(int major, int minor) implements Comparable<ImageVersion>
{
    static ImageVersion parse(String version) {
        String[] parts = version.split("\\.");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Invalid version: " + version);
        }
        try {
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            return new ImageVersion(major, minor);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version: " + version, e);
        }
    }

    @Override
    public int compareTo(@NonNull ImageVersion o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return Comparator.comparingInt(ImageVersion::major).thenComparingInt(ImageVersion::minor).compare(this, o);
    }
}

