/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainers.aerospike.enterprise;

import com.playtika.testcontainer.aerospike.AerospikeProperties;
import com.playtika.testcontainer.aerospike.EmbeddedAerospikeBootstrapConfiguration;
import com.playtika.testcontainers.aerospike.enterprise.AerospikeEnterpriseConfigurer;
import com.playtika.testcontainers.aerospike.enterprise.AerospikeEnterpriseProperties;
import com.playtika.testcontainers.aerospike.enterprise.ImageVersion;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.testcontainers.containers.GenericContainer;

@AutoConfiguration(after={EmbeddedAerospikeBootstrapConfiguration.class})
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnProperty(value={"embedded.aerospike.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={AerospikeEnterpriseProperties.class})
@PropertySource(value={"classpath:/embedded-enterprise-aerospike.properties"})
public class SetupEnterpriseAerospikeBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SetupEnterpriseAerospikeBootstrapConfiguration.class);
    private static final String DOCKER_IMAGE = "aerospike/aerospike-server-enterprise:6.3.0.16_1";
    private static final String AEROSPIKE_DOCKER_IMAGE_PROPERTY = "embedded.aerospike.dockerImage";
    private static final ImageVersion SUITABLE_IMAGE_VERSION = new ImageVersion(6, 3);
    private static final String TEXT_TO_DOCUMENTATION = "Documentation: https://github.com/PlaytikaOSS/testcontainers-spring-boot/blob/develop/embedded-aerospike-enterprise/README.adoc";
    private GenericContainer<?> aerospikeContainer;
    private AerospikeProperties aerospikeProperties;
    private AerospikeEnterpriseProperties aerospikeEnterpriseProperties;
    private Environment environment;

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Autowired
    @Qualifier(value="aerospike")
    public void setAerospikeContainer(GenericContainer<?> aerospikeContainer) {
        this.aerospikeContainer = aerospikeContainer;
    }

    @Autowired
    public void setAerospikeProperties(AerospikeProperties aerospikeProperties) {
        this.aerospikeProperties = aerospikeProperties;
    }

    @Autowired
    public void setAerospikeEnterpriseProperties(AerospikeEnterpriseProperties aerospikeEnterpriseProperties) {
        this.aerospikeEnterpriseProperties = aerospikeEnterpriseProperties;
    }

    @PostConstruct
    public void setupEnterpriseAerospike() throws IOException, InterruptedException {
        this.verifyAerospikeImage();
        AerospikeEnterpriseConfigurer aerospikeEnterpriseConfigurer = new AerospikeEnterpriseConfigurer(this.aerospikeProperties, this.aerospikeEnterpriseProperties);
        aerospikeEnterpriseConfigurer.configure(this.aerospikeContainer);
    }

    private void verifyAerospikeImage() {
        log.info("Verify Aerospike Enterprise Image");
        String dockerImage = this.environment.getProperty(AEROSPIKE_DOCKER_IMAGE_PROPERTY);
        if (dockerImage == null) {
            throw new IllegalStateException("Aerospike enterprise docker image not provided, set up 'embedded.aerospike.dockerImage' property.\nDocumentation: https://github.com/PlaytikaOSS/testcontainers-spring-boot/blob/develop/embedded-aerospike-enterprise/README.adoc");
        }
        if (!this.isEnterpriseImage(dockerImage)) {
            throw this.illegalAerospikeImageException();
        }
    }

    private IllegalStateException illegalAerospikeImageException() {
        return new IllegalStateException("You should use enterprise image for the Aerospike container with equal or higher version: aerospike/aerospike-server-enterprise:6.3.0.16_1. Container enable 'disallow-expunge' config option to prevent non-durable deletes, and this config option is available starting with version 6.3. Enterprise image is required, as non-durable deletes are not available in Community.Documentation: https://github.com/PlaytikaOSS/testcontainers-spring-boot/blob/develop/embedded-aerospike-enterprise/README.adoc");
    }

    private boolean isEnterpriseImage(String dockerImage) {
        return dockerImage.contains("enterprise") && this.isSuitableVersion(dockerImage);
    }

    private boolean isSuitableVersion(String dockerImage) {
        int index = dockerImage.indexOf(":");
        if (index == -1) {
            throw new IllegalStateException("Invalid docker image version format: " + dockerImage + ".\nDocumentation: https://github.com/PlaytikaOSS/testcontainers-spring-boot/blob/develop/embedded-aerospike-enterprise/README.adoc");
        }
        String version = dockerImage.substring(index + 1);
        ImageVersion imageVersion = ImageVersion.parse(version);
        return imageVersion.compareTo(SUITABLE_IMAGE_VERSION) >= 0;
    }
}

