/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainers.aerospike.enterprise;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;

public class AsadmCommandExecutor {
    private static final Logger log = LoggerFactory.getLogger(AsadmCommandExecutor.class);
    private final GenericContainer<?> aerospikeContainer;

    public void execute(String command) throws IOException, InterruptedException {
        Container.ExecResult result = this.aerospikeContainer.execInContainer(new String[]{"asadm", "--enable", "-e", command});
        AsadmCommandExecutor.logStdout(result);
        if (result.getExitCode() != 0 || this.isBadResponse(result)) {
            throw new IllegalStateException(String.format("Failed to execute  \"asadm --enable -e '%s'\":\nstdout:\n%s\nstderr:\n%s", command, result.getStdout(), result.getStderr()));
        }
    }

    private boolean isBadResponse(Container.ExecResult execResult) {
        String stdout = execResult.getStdout();
        return !stdout.contains("|ok");
    }

    private static void logStdout(Container.ExecResult result) {
        log.debug("Aerospike asadm util stdout: \n{}\n{}", (Object)result.getStdout(), (Object)result.getStderr());
    }

    public AsadmCommandExecutor(GenericContainer<?> aerospikeContainer) {
        this.aerospikeContainer = aerospikeContainer;
    }
}

