/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.aerospike;

import com.aerospike.client.AerospikeClient;
import com.playtika.test.aerospike.AerospikeProperties;
import com.playtika.test.aerospike.AerospikeTestOperations;
import com.playtika.test.aerospike.AerospikeTimeTravelService;
import com.playtika.test.aerospike.ExpiredDocumentsCleaner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.testcontainers.containers.GenericContainer;

@Configuration
@ConditionalOnBean(value={AerospikeClient.class, AerospikeProperties.class})
@ConditionalOnProperty(value={"embedded.aerospike.enabled"}, matchIfMissing=true)
public class AerospikeTestOperationsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ExpiredDocumentsCleaner expiredDocumentsCleaner(AerospikeClient client, AerospikeProperties properties) {
        return new ExpiredDocumentsCleaner(client, properties.getNamespace());
    }

    @Bean
    @ConditionalOnMissingBean
    public AerospikeTestOperations aerospikeTestOperations(ExpiredDocumentsCleaner expiredDocumentsCleaner, GenericContainer aerospike) {
        return new AerospikeTestOperations(expiredDocumentsCleaner, aerospike);
    }

    @Bean
    @ConditionalOnMissingBean
    public AerospikeTimeTravelService aerospikeTimeTravelService(AerospikeTestOperations aerospikeTestOperations) {
        return new AerospikeTimeTravelService(aerospikeTestOperations);
    }
}

