/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.aerospike;

import com.playtika.test.aerospike.ExpiredDocumentsCleaner;
import java.util.function.Supplier;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;

public class AerospikeTestOperations {
    private final ExpiredDocumentsCleaner expiredDocumentsCleaner;
    private final GenericContainer aerospike;

    public void addNetworkLatencyForResponses(long millis) {
        this.executeCommandInContainer(() -> {
            try {
                return this.aerospike.execInContainer(new String[]{"tc", "qdisc", "add", "dev", "eth0", "root", "netem", "delay", millis + "ms"});
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to execute command", e);
            }
        });
    }

    public void removeNetworkLatencyForResponses() {
        this.executeCommandInContainer(() -> {
            try {
                return this.aerospike.execInContainer(new String[]{"tc", "qdisc", "del", "dev", "eth0", "root"});
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to execute command", e);
            }
        });
    }

    public void addDuration(Duration duration) {
        this.timeTravel(DateTime.now().plus((ReadableDuration)duration).plusMinutes(1));
    }

    public void timeTravelTo(DateTime futureTime) {
        DateTime now = DateTime.now();
        if (futureTime.isBeforeNow()) {
            throw new IllegalArgumentException("Time should be in future. Now is: " + now + " time is:" + futureTime);
        }
        this.timeTravel(futureTime);
    }

    public void rollbackTime() {
        DateTimeUtils.setCurrentMillisSystem();
    }

    private void timeTravel(DateTime newNow) {
        DateTimeUtils.setCurrentMillisFixed((long)newNow.getMillis());
        this.expiredDocumentsCleaner.cleanExpiredDocumentsBefore(newNow.getMillis());
    }

    private void executeCommandInContainer(Supplier<Container.ExecResult> command) {
        Container.ExecResult execResult = command.get();
        if (!execResult.getStderr().isEmpty()) {
            throw new IllegalStateException("Failed to execute command with message: " + execResult.getStderr());
        }
    }

    public AerospikeTestOperations(ExpiredDocumentsCleaner expiredDocumentsCleaner, GenericContainer aerospike) {
        this.expiredDocumentsCleaner = expiredDocumentsCleaner;
        this.aerospike = aerospike;
    }
}

