/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.aerospike;

import com.aerospike.client.AerospikeClient;
import com.playtika.test.aerospike.AerospikeProperties;
import com.playtika.test.aerospike.AerospikeTestOperations;
import com.playtika.test.aerospike.AerospikeTimeTravelService;
import com.playtika.test.aerospike.ExpiredDocumentsCleaner;
import com.playtika.test.common.properties.InstallPackageProperties;
import com.playtika.test.common.utils.PackageInstaller;
import java.util.Collections;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.testcontainers.containers.GenericContainer;

@Configuration
@ConditionalOnBean(value={AerospikeClient.class, AerospikeProperties.class})
@ConditionalOnProperty(value={"embedded.aerospike.enabled"}, matchIfMissing=true)
public class AerospikeTestOperationsAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="embedded.aerospike.install")
    InstallPackageProperties aerospikePackageProperties() {
        InstallPackageProperties properties = new InstallPackageProperties();
        properties.setPackages(Collections.singleton("iproute2"));
        return properties;
    }

    @Bean
    PackageInstaller aerospikePackageInstaller(InstallPackageProperties aerospikePackageProperties, GenericContainer aerospike) {
        return new PackageInstaller(aerospikePackageProperties, aerospike);
    }

    @Bean
    @ConditionalOnMissingBean
    public ExpiredDocumentsCleaner expiredDocumentsCleaner(AerospikeClient client, AerospikeProperties properties) {
        return new ExpiredDocumentsCleaner(client, properties.getNamespace());
    }

    @Bean
    @ConditionalOnMissingBean
    public AerospikeTestOperations aerospikeTestOperations(ExpiredDocumentsCleaner expiredDocumentsCleaner, GenericContainer aerospike) {
        return new AerospikeTestOperations(expiredDocumentsCleaner, aerospike);
    }

    @Bean
    @ConditionalOnMissingBean
    public AerospikeTimeTravelService aerospikeTimeTravelService(AerospikeTestOperations aerospikeTestOperations) {
        return new AerospikeTimeTravelService(aerospikeTestOperations);
    }
}

