/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.aerospike;

import com.aerospike.client.AerospikeClient;
import com.playtika.test.common.spring.DependsOnPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureOrder
@ConditionalOnClass(value={AerospikeClient.class})
@ConditionalOnProperty(value={"embedded.aerospike.enabled"}, matchIfMissing=true)
public class EmbeddedAerospikeDependenciesAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedAerospikeDependenciesAutoConfiguration.class);

    @Configuration
    protected static class AerospikeClientPostProcessorConfiguration {
        protected AerospikeClientPostProcessorConfiguration() {
        }

        @Bean
        public BeanFactoryPostProcessor aerospikeClientDependencyPostProcessor() {
            return new DependsOnPostProcessor(AerospikeClient.class, new String[]{"aerospike"});
        }
    }
}

