/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.aerospike;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.NetworkSettings;
import com.github.dockerjava.api.model.Ports;
import com.playtika.test.aerospike.AerospikeProperties;
import com.playtika.test.common.checks.AbstractRetryingWaitStrategy;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;

public class AerospikeWaitStrategy
extends AbstractRetryingWaitStrategy {
    private static final Logger log = LoggerFactory.getLogger(AerospikeWaitStrategy.class);
    private final AerospikeProperties properties;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isReady() {
        String containerId = this.container.getContainerId();
        log.debug("Check Aerospike container {} status", (Object)containerId);
        InspectContainerResponse containerInfo = this.container.getContainerInfo();
        if (containerInfo == null) {
            log.debug("Aerospike container[{}] doesn't contain info. Abnormal situation, should not happen.", (Object)containerId);
            return false;
        }
        int port = this.getMappedPort(containerInfo.getNetworkSettings(), this.properties.port);
        String host = DockerClientFactory.instance().dockerHostIpAddress();
        try (AerospikeClient client = new AerospikeClient(host, port);){
            boolean bl = client.isConnected();
            return bl;
        }
        catch (AerospikeException.Connection e) {
            log.debug("Aerospike container: {} not yet started. {}", (Object)containerId, (Object)e.getMessage());
            return false;
        }
    }

    private int getMappedPort(NetworkSettings networkSettings, int originalPort) {
        ExposedPort exposedPort = new ExposedPort(originalPort);
        Ports ports = networkSettings.getPorts();
        Map bindings = ports.getBindings();
        Ports.Binding[] binding = (Ports.Binding[])bindings.get(exposedPort);
        return Integer.valueOf(binding[0].getHostPortSpec());
    }

    public AerospikeWaitStrategy(AerospikeProperties properties) {
        this.properties = properties;
    }
}

