/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.aerospike;

import com.aerospike.client.AerospikeClient;
import com.github.dockerjava.api.model.Capability;
import com.playtika.test.aerospike.AerospikeProperties;
import com.playtika.test.aerospike.AerospikeWaitStrategy;
import com.playtika.test.common.utils.ContainerUtils;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.HostPortWaitStrategy;
import org.testcontainers.containers.wait.WaitAllStrategy;
import org.testcontainers.containers.wait.WaitStrategy;

@Configuration
@AutoConfigureOrder(value=-2147483648)
@ConditionalOnProperty(value={"embedded.aerospike.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={AerospikeClient.class})
@EnableConfigurationProperties(value={AerospikeProperties.class})
public class EmbeddedAerospikeBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedAerospikeBootstrapConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public AerospikeWaitStrategy aerospikeStartupCheckStrategy(AerospikeProperties properties) {
        return new AerospikeWaitStrategy(properties);
    }

    @Bean(name={"aerospike"}, destroyMethod="stop")
    public GenericContainer aerospike(AerospikeWaitStrategy aerospikeWaitStrategy, ConfigurableEnvironment environment, AerospikeProperties properties) {
        log.info("Starting aerospike server. Docker image: {}", (Object)properties.dockerImage);
        WaitStrategy waitStrategy = new WaitAllStrategy().withStrategy((WaitStrategy)aerospikeWaitStrategy).withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS));
        GenericContainer aerospike = new GenericContainer(properties.dockerImage).withExposedPorts(new Integer[]{properties.port}).withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)log)).withEnv("NAMESPACE", properties.namespace).withEnv("SERVICE_PORT", String.valueOf(properties.port)).withEnv("MEM_GB", String.valueOf(1)).withEnv("STORAGE_GB", String.valueOf(1)).withCreateContainerCmdModifier(cmd -> cmd.withCapAdd(new Capability[]{Capability.NET_ADMIN})).waitingFor(waitStrategy);
        aerospike.start();
        this.registerAerospikeEnvironment(aerospike, environment, properties);
        return aerospike;
    }

    private void registerAerospikeEnvironment(GenericContainer aerospike, ConfigurableEnvironment environment, AerospikeProperties properties) {
        Integer mappedPort = aerospike.getMappedPort(properties.port);
        String host = aerospike.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.aerospike.host", host);
        map.put("embedded.aerospike.port", mappedPort);
        map.put("embedded.aerospike.namespace", properties.namespace);
        log.info("Started aerospike server. Connection details {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedAerospikeInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

