/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.aerospike;

import com.aerospike.client.AerospikeClient;
import com.playtika.test.aerospike.AerospikeProperties;
import com.playtika.test.aerospike.AerospikeWaitStrategy;
import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnClass(value={AerospikeClient.class})
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(value={"embedded.aerospike.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={AerospikeProperties.class})
public class EmbeddedAerospikeBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedAerospikeBootstrapConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public AerospikeWaitStrategy aerospikeStartupCheckStrategy(AerospikeProperties properties) {
        return new AerospikeWaitStrategy(properties);
    }

    @Bean(name={"aerospike"}, destroyMethod="stop")
    public GenericContainer aerospike(AerospikeWaitStrategy aerospikeWaitStrategy, ConfigurableEnvironment environment, AerospikeProperties properties) {
        WaitAllStrategy waitStrategy = new WaitAllStrategy().withStrategy((WaitStrategy)aerospikeWaitStrategy).withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStartupTimeout(properties.getTimeoutDuration());
        GenericContainer aerospike = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.port}).withEnv("NAMESPACE", properties.namespace).withEnv("SERVICE_PORT", String.valueOf(properties.port)).withEnv("MEM_GB", String.valueOf(1)).withEnv("STORAGE_GB", String.valueOf(1)).waitingFor((WaitStrategy)waitStrategy);
        String featureKey = properties.featureKey;
        if (featureKey != null) {
            aerospike.withEnv("FEATURES", featureKey).withEnv("FEATURE_KEY_FILE", "env-b64:FEATURES");
        }
        aerospike = ContainerUtils.configureCommonsAndStart((GenericContainer)aerospike, (CommonContainerProperties)properties, (Logger)log);
        this.registerAerospikeEnvironment(aerospike, environment, properties);
        return aerospike;
    }

    private void registerAerospikeEnvironment(GenericContainer aerospike, ConfigurableEnvironment environment, AerospikeProperties properties) {
        Integer mappedPort = aerospike.getMappedPort(properties.port);
        String host = aerospike.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.aerospike.host", host);
        map.put("embedded.aerospike.port", mappedPort);
        map.put("embedded.aerospike.namespace", properties.namespace);
        log.info("Started aerospike server. Connection details {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedAerospikeInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

