/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.aerospike;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.Language;
import com.aerospike.client.Value;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.ExecuteTask;
import com.aerospike.client.task.RegisterTask;
import com.playtika.test.aerospike.ExpiredDocumentsCleaner;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.springframework.util.Assert;

public class AerospikeExpiredDocumentsCleaner
implements ExpiredDocumentsCleaner {
    private static final String PACKAGE_NAME = "remove_expired";
    private static final String FUNC_NAME = "remove_expired";
    private static final String RESOURCE_PATH = "udf/remove_expired.lua";
    private static final String SERVER_PATH = "remove_expired.lua";
    private static final int SLEEP_INTERVAL = 100;
    private static final int TIMEOUT = 10000;
    private final AerospikeClient client;
    private final String namespace;

    public AerospikeExpiredDocumentsCleaner(AerospikeClient client, String namespace) {
        Assert.notNull((Object)client, (String)"Aerospike client can not be null");
        Assert.notNull((Object)namespace, (String)"Namespace can not be null");
        this.client = client;
        this.namespace = namespace;
        this.registerUdf();
    }

    private void registerUdf() {
        ClassLoader classLoader = AerospikeExpiredDocumentsCleaner.class.getClassLoader();
        RegisterTask registerTask = this.client.register(null, classLoader, RESOURCE_PATH, SERVER_PATH, Language.LUA);
        registerTask.waitTillComplete(100, 10000);
    }

    @Override
    public void cleanExpiredDocumentsBefore(Instant expireTime) {
        this.cleanExpiredDocumentsBefore(expireTime.toEpochMilli());
    }

    @Override
    public void cleanExpiredDocumentsBefore(long expireTimeMillis) {
        long duration = expireTimeMillis - System.currentTimeMillis();
        int expiration = (int)TimeUnit.MILLISECONDS.toSeconds(duration);
        Value value = Value.get((int)expiration);
        Statement statement = new Statement();
        statement.setNamespace(this.namespace);
        ExecuteTask executeTask = this.client.execute(null, statement, "remove_expired", "remove_expired", new Value[]{value});
        executeTask.waitTillComplete(100, 10000);
    }
}

