/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.aerospike;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.NetworkSettings;
import com.github.dockerjava.api.model.Ports;
import com.playtika.testcontainer.aerospike.AerospikeProperties;
import com.playtika.testcontainer.common.checks.AbstractRetryingWaitStrategy;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;

public class AerospikeWaitStrategy
extends AbstractRetryingWaitStrategy {
    private static final Logger log = LoggerFactory.getLogger(AerospikeWaitStrategy.class);
    private final AerospikeProperties properties;

    protected boolean isReady() {
        boolean bl;
        String containerId = this.waitStrategyTarget.getContainerId();
        log.debug("Check Aerospike container {} status", (Object)containerId);
        InspectContainerResponse containerInfo = this.waitStrategyTarget.getContainerInfo();
        if (containerInfo == null) {
            log.debug("Aerospike container[{}] doesn't contain info. Abnormal situation, should not happen.", (Object)containerId);
            return false;
        }
        int port = this.getMappedPort(containerInfo.getNetworkSettings(), this.properties.port);
        String host = DockerClientFactory.instance().dockerHostIpAddress();
        AerospikeClient client = new AerospikeClient(host, port);
        try {
            bl = client.isConnected();
        }
        catch (Throwable throwable) {
            try {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (AerospikeException.Connection e) {
                log.debug("Aerospike container: {} not yet started. {}", (Object)containerId, (Object)e.getMessage());
                return false;
            }
        }
        client.close();
        return bl;
    }

    private int getMappedPort(NetworkSettings networkSettings, int originalPort) {
        ExposedPort exposedPort = new ExposedPort(originalPort);
        Ports ports = networkSettings.getPorts();
        Map bindings = ports.getBindings();
        Ports.Binding[] binding = (Ports.Binding[])bindings.get(exposedPort);
        return Integer.valueOf(binding[0].getHostPortSpec());
    }

    public AerospikeWaitStrategy(AerospikeProperties properties) {
        this.properties = properties;
    }
}

