/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.aerospike;

import com.playtika.test.aerospike.ExpiredDocumentsCleaner;
import com.playtika.test.common.operations.NetworkTestOperations;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.springframework.util.StringUtils;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;

public class AerospikeTestOperations {
    private final ExpiredDocumentsCleaner expiredDocumentsCleaner;
    private final NetworkTestOperations networkTestOperations;
    private final GenericContainer<?> aerospikeContainer;

    @Deprecated
    public void addNetworkLatencyForResponses(java.time.Duration millis) {
        this.networkTestOperations.addNetworkLatencyForResponses(millis);
    }

    @Deprecated
    public void removeNetworkLatencyForResponses() {
        this.networkTestOperations.removeNetworkLatencyForResponses();
    }

    public void addDuration(Duration duration) {
        this.timeTravel(DateTime.now().plus((ReadableDuration)duration).plusMinutes(1));
    }

    public void timeTravelTo(DateTime futureTime) {
        DateTime now = DateTime.now();
        if (futureTime.isBeforeNow()) {
            throw new IllegalArgumentException("Time should be in future. Now is: " + now + " time is:" + futureTime);
        }
        this.timeTravel(futureTime);
    }

    public void rollbackTime() {
        DateTimeUtils.setCurrentMillisSystem();
    }

    private void timeTravel(DateTime newNow) {
        DateTimeUtils.setCurrentMillisFixed((long)newNow.getMillis());
        this.expiredDocumentsCleaner.cleanExpiredDocumentsBefore(newNow.getMillis());
    }

    public List<ScanJob> getScans() {
        Container.ExecResult execResult = this.aerospikeContainer.execInContainer(new String[]{"asinfo", "-v", "scan-show"});
        String stdout = execResult.getStdout();
        return this.getScanJobs(stdout);
    }

    private List<ScanJob> getScanJobs(String stdout) {
        if (!StringUtils.hasText((String)stdout)) {
            return Collections.emptyList();
        }
        return Arrays.stream(stdout.replaceAll("\n", "").split(";")).map(this::parseToObScanJobObject).collect(Collectors.toList());
    }

    private ScanJob parseToObScanJobObject(String job) {
        String[] pairs = job.split(":");
        Map<String, String> pairsMap = Arrays.stream(pairs).map(pair -> {
            String[] kv = pair.split("=");
            return new AbstractMap.SimpleEntry<String, String>(kv[0], kv[1]);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return ScanJob.builder().module(pairsMap.get("module")).set(pairsMap.get("set")).udfFunction(pairsMap.get("udf-function")).status(pairsMap.get("status")).trid(pairsMap.get("trid")).namespace(pairsMap.get("ns")).build();
    }

    public void killAllScans() {
        Container.ExecResult execResult = this.aerospikeContainer.execInContainer(new String[]{"asinfo", "-v", "scan-abort-all:"});
        ((AbstractStringAssert)Assertions.assertThat((String)execResult.getStdout()).as("Scan jobs killed", new Object[0])).contains(new CharSequence[]{"OK"});
    }

    public void assertNoScans() {
        this.assertNoScans(scanJob -> true);
    }

    public void assertNoScans(Predicate<ScanJob> scanJobPredicate) {
        List scanJobs = this.getScans().stream().filter(scanJobPredicate).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(scanJobs).as("Scan jobs", new Object[0])).isEmpty();
    }

    public void assertNoScansForSet(String setName) {
        this.assertNoScans(job -> setName.equals(job.set));
    }

    public AerospikeTestOperations(ExpiredDocumentsCleaner expiredDocumentsCleaner, NetworkTestOperations networkTestOperations, GenericContainer<?> aerospikeContainer) {
        this.expiredDocumentsCleaner = expiredDocumentsCleaner;
        this.networkTestOperations = networkTestOperations;
        this.aerospikeContainer = aerospikeContainer;
    }

    public static final class ScanJob {
        private final String module;
        private final String set;
        private final String udfFunction;
        private final String status;
        private final String trid;
        private final String namespace;

        ScanJob(String module, String set, String udfFunction, String status, String trid, String namespace) {
            this.module = module;
            this.set = set;
            this.udfFunction = udfFunction;
            this.status = status;
            this.trid = trid;
            this.namespace = namespace;
        }

        public static ScanJobBuilder builder() {
            return new ScanJobBuilder();
        }

        public String getModule() {
            return this.module;
        }

        public String getSet() {
            return this.set;
        }

        public String getUdfFunction() {
            return this.udfFunction;
        }

        public String getStatus() {
            return this.status;
        }

        public String getTrid() {
            return this.trid;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScanJob)) {
                return false;
            }
            ScanJob other = (ScanJob)o;
            String this$module = this.getModule();
            String other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            String this$set = this.getSet();
            String other$set = other.getSet();
            if (this$set == null ? other$set != null : !this$set.equals(other$set)) {
                return false;
            }
            String this$udfFunction = this.getUdfFunction();
            String other$udfFunction = other.getUdfFunction();
            if (this$udfFunction == null ? other$udfFunction != null : !this$udfFunction.equals(other$udfFunction)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$trid = this.getTrid();
            String other$trid = other.getTrid();
            if (this$trid == null ? other$trid != null : !this$trid.equals(other$trid)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            String $set = this.getSet();
            result = result * 59 + ($set == null ? 43 : $set.hashCode());
            String $udfFunction = this.getUdfFunction();
            result = result * 59 + ($udfFunction == null ? 43 : $udfFunction.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $trid = this.getTrid();
            result = result * 59 + ($trid == null ? 43 : $trid.hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            return result;
        }

        public String toString() {
            return "AerospikeTestOperations.ScanJob(module=" + this.getModule() + ", set=" + this.getSet() + ", udfFunction=" + this.getUdfFunction() + ", status=" + this.getStatus() + ", trid=" + this.getTrid() + ", namespace=" + this.getNamespace() + ")";
        }

        public static class ScanJobBuilder {
            private String module;
            private String set;
            private String udfFunction;
            private String status;
            private String trid;
            private String namespace;

            ScanJobBuilder() {
            }

            public ScanJobBuilder module(String module) {
                this.module = module;
                return this;
            }

            public ScanJobBuilder set(String set) {
                this.set = set;
                return this;
            }

            public ScanJobBuilder udfFunction(String udfFunction) {
                this.udfFunction = udfFunction;
                return this;
            }

            public ScanJobBuilder status(String status) {
                this.status = status;
                return this;
            }

            public ScanJobBuilder trid(String trid) {
                this.trid = trid;
                return this;
            }

            public ScanJobBuilder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            public ScanJob build() {
                return new ScanJob(this.module, this.set, this.udfFunction, this.status, this.trid, this.namespace);
            }

            public String toString() {
                return "AerospikeTestOperations.ScanJob.ScanJobBuilder(module=" + this.module + ", set=" + this.set + ", udfFunction=" + this.udfFunction + ", status=" + this.status + ", trid=" + this.trid + ", namespace=" + this.namespace + ")";
            }
        }
    }
}

