/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.aerospike;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;

public class DateTimeUtils {
    private static volatile EmbeddedMillisProvider timeMillis;
    private static final SystemTimeMillisProvider SYSTEM_TIME;

    public static OffsetDateTime now() {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(DateTimeUtils.currentTimeMillis()), ZoneId.systemDefault());
    }

    public static long currentTimeMillis() {
        return timeMillis.getMillis();
    }

    public static void setCurrentMillisSystem() throws SecurityException {
        timeMillis = SYSTEM_TIME;
    }

    public static void setCurrentMillisFixed(long currentMilliseconds) throws SecurityException {
        timeMillis = new FixedTimeMillisProvider(currentMilliseconds);
    }

    static {
        SYSTEM_TIME = new SystemTimeMillisProvider();
        timeMillis = SYSTEM_TIME;
    }

    public static interface EmbeddedMillisProvider {
        public long getMillis();
    }

    static class SystemTimeMillisProvider
    implements EmbeddedMillisProvider {
        SystemTimeMillisProvider() {
        }

        @Override
        public long getMillis() {
            return System.currentTimeMillis();
        }
    }

    static class FixedTimeMillisProvider
    implements EmbeddedMillisProvider {
        private final long iMillis;

        FixedTimeMillisProvider(long millis) {
            this.iMillis = millis;
        }

        @Override
        public long getMillis() {
            return this.iMillis;
        }
    }
}

