/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.aerospike;

import com.aerospike.client.AerospikeClient;
import com.playtika.testcontainer.common.spring.DependsOnPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration
@AutoConfigureOrder
@ConditionalOnClass(value={AerospikeClient.class})
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnProperty(value={"embedded.aerospike.enabled"}, matchIfMissing=true)
public class EmbeddedAerospikeDependenciesAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedAerospikeDependenciesAutoConfiguration.class);

    @Configuration
    protected static class AerospikeClientPostProcessorConfiguration {
        protected AerospikeClientPostProcessorConfiguration() {
        }

        @Bean
        public static BeanFactoryPostProcessor aerospikeClientDependencyPostProcessor() {
            return new DependsOnPostProcessor(AerospikeClient.class, new String[]{"aerospike"});
        }
    }
}

