/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.aerospike;

import com.aerospike.client.IAerospikeClient;
import com.playtika.testcontainer.aerospike.AerospikeProperties;
import com.playtika.testcontainer.aerospike.AerospikeWaitStrategy;
import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.toxiproxy.EmbeddedToxiProxyBootstrapConfiguration;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnClass(value={IAerospikeClient.class})
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class, EmbeddedToxiProxyBootstrapConfiguration.class})
@ConditionalOnProperty(value={"embedded.aerospike.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={AerospikeProperties.class})
public class EmbeddedAerospikeBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedAerospikeBootstrapConfiguration.class);
    private static final String AEROSPIKE_NETWORK_ALIAS = "aerospike.testcontainer.docker";

    @Bean
    @ConditionalOnMissingBean
    public AerospikeWaitStrategy aerospikeStartupCheckStrategy(AerospikeProperties properties) {
        return new AerospikeWaitStrategy(properties);
    }

    @Bean
    @ConditionalOnToxiProxyEnabled(module="aerospike")
    ToxiproxyContainer.ContainerProxy aerospikeContainerProxy(ToxiproxyContainer toxiproxyContainer, GenericContainer<?> aerospike, AerospikeProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy(aerospike, properties.port);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.aerospike.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.aerospike.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.aerospike.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedAerospikeToxiProxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Aerospike ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"aerospike"}, destroyMethod="stop")
    public GenericContainer<?> aerospike(AerospikeWaitStrategy aerospikeWaitStrategy, ConfigurableEnvironment environment, AerospikeProperties properties, Optional<Network> network) {
        WaitAllStrategy waitStrategy = new WaitAllStrategy().withStrategy((WaitStrategy)aerospikeWaitStrategy).withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStartupTimeout(properties.getTimeoutDuration());
        GenericContainer aerospike = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.port}).withEnv("NAMESPACE", properties.namespace).withEnv("SERVICE_PORT", String.valueOf(properties.port)).withEnv("MEM_GB", String.valueOf(1)).withEnv("STORAGE_GB", String.valueOf(1)).withNetworkAliases(new String[]{AEROSPIKE_NETWORK_ALIAS}).waitingFor((WaitStrategy)waitStrategy);
        network.ifPresent(arg_0 -> ((GenericContainer)aerospike).withNetwork(arg_0));
        String featureKey = properties.featureKey;
        if (featureKey != null) {
            aerospike.withEnv("FEATURES", featureKey).withEnv("FEATURE_KEY_FILE", "env-b64:FEATURES");
        }
        aerospike = ContainerUtils.configureCommonsAndStart((GenericContainer)aerospike, (CommonContainerProperties)properties, (Logger)log);
        this.registerAerospikeEnvironment(aerospike, environment, properties);
        return aerospike;
    }

    private void registerAerospikeEnvironment(GenericContainer<?> aerospike, ConfigurableEnvironment environment, AerospikeProperties properties) {
        Integer mappedPort = aerospike.getMappedPort(properties.port);
        String host = aerospike.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.aerospike.host", host);
        map.put("embedded.aerospike.port", mappedPort);
        map.put("embedded.aerospike.namespace", properties.namespace);
        map.put("embedded.aerospike.networkAlias", AEROSPIKE_NETWORK_ALIAS);
        map.put("embedded.aerospike.internalPort", properties.port);
        log.info("Started aerospike server. Connection details {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedAerospikeInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

