/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.aerospike;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Language;
import com.aerospike.client.Value;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.ExecuteTask;
import com.aerospike.client.task.RegisterTask;
import com.playtika.testcontainer.aerospike.ExpiredDocumentsCleaner;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.springframework.util.Assert;

public class AerospikeExpiredDocumentsCleaner
implements ExpiredDocumentsCleaner {
    private static final String PACKAGE_NAME = "remove_expired";
    private static final String FUNC_NAME = "remove_expired";
    private static final String RESOURCE_PATH = "udf/remove_expired.lua";
    private static final String SERVER_PATH = "remove_expired.lua";
    private static final int SLEEP_INTERVAL = 100;
    private static final int TIMEOUT = 10000;
    private final IAerospikeClient client;
    private final String namespace;
    private final boolean durableDelete;

    public AerospikeExpiredDocumentsCleaner(IAerospikeClient client, String namespace, boolean durableDelete) {
        Assert.notNull((Object)client, (String)"Aerospike client can not be null");
        Assert.notNull((Object)namespace, (String)"Namespace can not be null");
        this.client = client;
        this.namespace = namespace;
        this.durableDelete = durableDelete;
        this.registerUdf();
    }

    public AerospikeExpiredDocumentsCleaner(IAerospikeClient client, String namespace) {
        this(client, namespace, false);
    }

    private void registerUdf() {
        ClassLoader classLoader = AerospikeExpiredDocumentsCleaner.class.getClassLoader();
        RegisterTask registerTask = this.client.register(null, classLoader, RESOURCE_PATH, SERVER_PATH, Language.LUA);
        registerTask.waitTillComplete(100, 10000);
    }

    @Override
    public void cleanExpiredDocumentsBefore(Instant expireTime) {
        this.cleanExpiredDocumentsBefore(expireTime.toEpochMilli());
    }

    @Override
    public void cleanExpiredDocumentsBefore(long expireTimeMillis) {
        long duration = expireTimeMillis - System.currentTimeMillis();
        int expiration = (int)TimeUnit.MILLISECONDS.toSeconds(duration);
        Value value = Value.get((int)expiration);
        Statement statement = new Statement();
        statement.setNamespace(this.namespace);
        WritePolicy writePolicy = new WritePolicy(this.client.getWritePolicyDefault());
        writePolicy.durableDelete = this.durableDelete;
        ExecuteTask executeTask = this.client.execute(writePolicy, statement, "remove_expired", "remove_expired", new Value[]{value});
        executeTask.waitTillComplete(100, 10000);
    }
}

